/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.util.FileUtils;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

public class AbstractScmAccessor
implements ResourceLoaderAware {
    private static final String[] DEFAULT_LOCATIONS = new String[]{"/"};
    protected Log logger = LogFactory.getLog(this.getClass());
    private File basedir;
    private String uri;
    private ConfigurableEnvironment environment;
    private String username;
    private String password;
    private String[] searchPaths = DEFAULT_LOCATIONS;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();

    public AbstractScmAccessor(ConfigurableEnvironment environment) {
        this.environment = environment;
        this.basedir = this.createBaseDir();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected File createBaseDir() {
        try {
            final File basedir = Files.createTempDirectory("config-repo-", new FileAttribute[0]).toFile();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        FileUtils.delete((File)basedir, (int)1);
                    }
                    catch (IOException e) {
                        AbstractScmAccessor.this.logger.warn((Object)("Failed to delete temporary directory on exit: " + e));
                    }
                }
            });
            return basedir;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create temp dir", e);
        }
    }

    public ConfigurableEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public void setUri(String uri) {
        while (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        int index = uri.indexOf("://");
        if (index > 0 && !uri.substring(index + "://".length()).contains("/")) {
            uri = String.valueOf(uri) + "/";
        }
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir.getAbsoluteFile();
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setSearchPaths(String ... searchPaths) {
        this.searchPaths = searchPaths;
    }

    public String[] getSearchPaths() {
        return this.searchPaths;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected File getWorkingDirectory() {
        if (this.uri.startsWith("file:")) {
            try {
                return new UrlResource(StringUtils.cleanPath((String)this.uri)).getFile();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot convert uri to file: " + this.uri);
            }
        }
        return this.basedir;
    }

    protected String[] getSearchLocations(File dir, String application, String profile, String label) {
        String[] locations = this.searchPaths;
        locations = locations == null || locations.length == 0 ? DEFAULT_LOCATIONS : StringUtils.concatenateStringArrays((String[])DEFAULT_LOCATIONS, (String[])locations);
        LinkedHashSet<String> output = new LinkedHashSet<String>();
        String[] stringArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            String[] profiles = new String[]{profile};
            if (profile != null) {
                profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
            }
            String[] stringArray2 = profiles;
            int n3 = profiles.length;
            int n4 = 0;
            while (n4 < n3) {
                String prof = stringArray2[n4];
                String value = location;
                if (application != null) {
                    value = value.replace("{application}", application);
                }
                if (prof != null) {
                    value = value.replace("{profile}", prof);
                }
                if (label != null) {
                    value = value.replace("{label}", label);
                }
                if (!value.endsWith("/")) {
                    value = String.valueOf(value) + "/";
                }
                output.addAll(this.matchingDirectories(dir, value));
                ++n4;
            }
            ++n2;
        }
        return output.toArray(new String[0]);
    }

    private List<String> matchingDirectories(File dir, String value) {
        ArrayList<String> output = new ArrayList<String>();
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
            String path = new File(dir, value).toURI().toString();
            Resource[] resourceArray = resolver.getResources(path);
            int n = resourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Resource resource = resourceArray[n2];
                if (resource.getFile().isDirectory()) {
                    output.add(resource.getURI().toString());
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return output;
    }
}

