/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.resource.NoSuchResourceException;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.cloud.config.server.support.EnvironmentPropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.http.HttpStatus;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(method={RequestMethod.GET}, path={"${spring.cloud.config.server.prefix:}"})
public class ResourceController {
    private ResourceRepository resourceRepository;
    private EnvironmentRepository environmentRepository;

    public ResourceController(ResourceRepository resourceRepository, EnvironmentRepository environmentRepository) {
        this.resourceRepository = resourceRepository;
        this.environmentRepository = environmentRepository;
    }

    @RequestMapping(value={"/{name}/{profile}/{label}/{path:.*}"})
    public synchronized String resolve(@PathVariable String name, @PathVariable String profile, @PathVariable String label, @PathVariable String path) throws IOException {
        if (label != null && label.contains("(_)")) {
            label = label.replace("(_)", "/");
        }
        StandardEnvironment environment = EnvironmentPropertySource.prepareEnvironment(this.environmentRepository.findOne(name, profile, label));
        try (InputStream is = this.resourceRepository.findOne(name, profile, label, path).getInputStream();){
            String text = StreamUtils.copyToString((InputStream)is, (Charset)Charset.forName("UTF-8"));
            String string = EnvironmentPropertySource.resolvePlaceholders(environment, text);
            return string;
        }
    }

    @RequestMapping(value={"/{name}/{profile}/{label}/{path:.*}"}, produces={"application/octet-stream"})
    public synchronized byte[] binary(@PathVariable String name, @PathVariable String profile, @PathVariable String label, @PathVariable String path) throws IOException {
        if (label != null && label.contains("(_)")) {
            label = label.replace("(_)", "/");
        }
        EnvironmentPropertySource.prepareEnvironment(this.environmentRepository.findOne(name, profile, label));
        try (InputStream is = this.resourceRepository.findOne(name, profile, label, path).getInputStream();){
            byte[] byArray = StreamUtils.copyToByteArray((InputStream)is);
            return byArray;
        }
    }

    @ExceptionHandler(value={NoSuchResourceException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void notFound(NoSuchResourceException e) {
    }
}

