/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.bootstrap;

import java.util.Collections;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class ConfigServerBootstrapApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    public static final int DEFAULT_ORDER = -2147483644;
    private int order = -2147483644;
    private PropertySource<?> propertySource = new MapPropertySource("configServerClient", Collections.singletonMap("spring.cloud.config.enabled", "false"));

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        if (!environment.resolvePlaceholders("${spring.cloud.config.enabled:false}").equalsIgnoreCase("true") && !environment.getPropertySources().contains(this.propertySource.getName())) {
            environment.getPropertySources().addLast(this.propertySource);
        }
    }
}

