/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.cloud.bootstrap.encrypt.RsaProperties;
import org.springframework.cloud.config.server.config.DefaultTextEncryptorConfiguration;
import org.springframework.cloud.config.server.config.SingleTextEncryptorConfiguration;
import org.springframework.cloud.config.server.encryption.CipherEnvironmentEncryptor;
import org.springframework.cloud.config.server.encryption.EnvironmentEncryptor;
import org.springframework.cloud.config.server.encryption.KeyStoreTextEncryptorLocator;
import org.springframework.cloud.config.server.encryption.SingleTextEncryptorLocator;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.KeyStoreKeyFactory;
import org.springframework.security.rsa.crypto.RsaAlgorithm;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;

@Configuration
@EnableConfigurationProperties(value={KeyProperties.class})
@Import(value={SingleTextEncryptorConfiguration.class, DefaultTextEncryptorConfiguration.class})
public class EncryptionAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={RsaSecretEncryptor.class})
    @ConditionalOnProperty(prefix="encrypt.keyStore", value={"location"}, matchIfMissing=false)
    protected static class KeyStoreConfiguration {
        @Autowired
        private KeyProperties key;
        @Autowired
        private RsaProperties rsaProperties;

        protected KeyStoreConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public TextEncryptorLocator textEncryptorLocator() {
            KeyProperties.KeyStore keyStore = this.key.getKeyStore();
            KeyStoreTextEncryptorLocator locator = new KeyStoreTextEncryptorLocator(new KeyStoreKeyFactory(keyStore.getLocation(), keyStore.getPassword().toCharArray()), keyStore.getSecret(), keyStore.getAlias());
            RsaAlgorithm algorithm = this.rsaProperties.getAlgorithm();
            locator.setRsaAlgorithm(algorithm);
            locator.setSalt(this.rsaProperties.getSalt());
            locator.setStrong(this.rsaProperties.isStrong());
            return locator;
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"spring.cloud.config.server.encrypt.enabled"}, matchIfMissing=true)
    protected static class EncryptorConfiguration {
        @Autowired(required=false)
        private TextEncryptorLocator locator;
        @Autowired
        private TextEncryptor encryptor;

        protected EncryptorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public EnvironmentEncryptor environmentEncryptor() {
            TextEncryptorLocator locator = this.locator;
            if (locator == null) {
                locator = new SingleTextEncryptorLocator(this.encryptor);
            }
            return new CipherEnvironmentEncryptor(locator);
        }
    }
}

