/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@ConfigurationProperties(value="spring.cloud.config.server.consul.watch")
public class ConsulEnvironmentWatch
implements EnvironmentWatch {
    public static final String CONSUL_INDEX = "X-Consul-Index";
    public static final String CONSUL_TOKEN = "X-Consul-Token";
    private static Log LOG = LogFactory.getLog(ConsulEnvironmentWatch.class);
    private static final String WATCH_URL = "{scheme}://{host}:{port}/v1/kv/{path}?keys&recurse&wait={wait}&index={index}";
    public static final ParameterizedTypeReference<List<String>> RESPONSE_TYPE = new ParameterizedTypeReference<List<String>>(){};
    private RestTemplate restTemplate = new RestTemplate();
    @NotNull
    private String scheme = "http";
    @NotNull
    private String host = "localhost";
    @NotNull
    private int port = 8500;
    @NotNull
    private String path;
    @NotNull
    private String wait = "3m";
    private String token;

    @Override
    public String watch(String state) {
        block4: {
            ArrayList<String> params = new ArrayList<String>();
            params.add(this.scheme);
            params.add(this.host);
            params.add(String.valueOf(this.port));
            params.add(this.path);
            params.add(this.wait);
            params.add(StringUtils.hasText((String)state) ? state : "");
            try {
                HttpEntity request;
                ResponseEntity response;
                HttpHeaders headers = new HttpHeaders();
                if (StringUtils.hasText((String)this.token)) {
                    headers.add(CONSUL_TOKEN, this.token);
                }
                if ((response = this.restTemplate.exchange(WATCH_URL, HttpMethod.GET, request = new HttpEntity((MultiValueMap)headers), RESPONSE_TYPE, params.toArray())).getStatusCode().is2xxSuccessful()) {
                    String consulIndex = response.getHeaders().getFirst(CONSUL_INDEX);
                    return consulIndex;
                }
            }
            catch (HttpStatusCodeException e) {
                if (e.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) break block4;
                LOG.error((Object)("Unable to watch consul path " + this.path), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPath(String path) {
        this.path = path;
        if (this.path.startsWith("/")) {
            this.path = this.path.substring(1);
        }
    }

    public void setWait(String wait) {
        this.wait = wait;
    }

    public void setToken(String token) {
        this.token = token;
    }
}

