/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.core.Ordered;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public abstract class AbstractVaultEnvironmentRepository
implements EnvironmentRepository,
Ordered {
    private static Log log = LogFactory.getLog(AbstractVaultEnvironmentRepository.class);
    protected final ObjectProvider<HttpServletRequest> request;
    protected final EnvironmentWatch watch;
    protected String defaultKey;
    @NotEmpty
    protected String profileSeparator;
    protected int order;

    public AbstractVaultEnvironmentRepository(ObjectProvider<HttpServletRequest> request, EnvironmentWatch watch, VaultEnvironmentProperties properties) {
        this.defaultKey = properties.getDefaultKey();
        this.profileSeparator = properties.getProfileSeparator();
        this.order = properties.getOrder();
        this.request = request;
        this.watch = watch;
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        List<String> scrubbedProfiles = this.scrubProfiles(profiles);
        List<String> keys = this.findKeys(application, scrubbedProfiles);
        Environment environment = new Environment(application, profiles, label, null, this.getWatchState());
        for (String key : keys) {
            String data = this.read(key);
            if (data == null) continue;
            YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
            yaml.setResources(new Resource[]{new ByteArrayResource(data.getBytes())});
            Properties properties = yaml.getObject();
            if (properties.isEmpty()) continue;
            environment.add(new PropertySource("vault:" + key, (Map)properties));
        }
        return environment;
    }

    protected abstract String read(String var1);

    private String getWatchState() {
        HttpServletRequest servletRequest = (HttpServletRequest)this.request.getIfAvailable();
        if (servletRequest != null) {
            try {
                String state = servletRequest.getHeader("X-Config-State");
                return this.watch.watch(state);
            }
            catch (IllegalStateException e) {
                log.debug((Object)"Could not get state.", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private List<String> findKeys(String application, List<String> profiles) {
        String[] applications;
        ArrayList<String> keys = new ArrayList<String>();
        if (StringUtils.hasText((String)this.defaultKey) && !this.defaultKey.equals(application)) {
            keys.add(this.defaultKey);
            this.addProfiles(keys, this.defaultKey, profiles);
        }
        for (String app : applications = StringUtils.commaDelimitedListToStringArray((String)application)) {
            keys.add(app);
            this.addProfiles(keys, app, profiles);
        }
        Collections.reverse(keys);
        return keys;
    }

    private List<String> scrubProfiles(String[] profiles) {
        ArrayList<String> scrubbedProfiles = new ArrayList<String>(Arrays.asList(profiles));
        scrubbedProfiles.remove("default");
        return scrubbedProfiles;
    }

    private void addProfiles(List<String> contexts, String baseContext, List<String> profiles) {
        for (String profile : profiles) {
            contexts.add(baseContext + this.profileSeparator + profile);
        }
    }

    public void setDefaultKey(String defaultKey) {
        this.defaultKey = defaultKey;
    }

    public void setProfileSeparator(String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

