/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.AwsSecretsManagerEnvironmentProperties;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.ResourceNotFoundException;

public class AwsSecretsManagerEnvironmentRepository
implements EnvironmentRepository,
Ordered {
    private static final Log log = LogFactory.getLog(AwsSecretsManagerEnvironmentRepository.class);
    private final ObjectMapper objectMapper;
    private final SecretsManagerClient awsSmClient;
    private final ConfigServerProperties configServerProperties;
    private final AwsSecretsManagerEnvironmentProperties environmentProperties;
    private final int order;

    public AwsSecretsManagerEnvironmentRepository(SecretsManagerClient awsSmClient, ConfigServerProperties configServerProperties, AwsSecretsManagerEnvironmentProperties environmentProperties) {
        this.awsSmClient = awsSmClient;
        this.configServerProperties = configServerProperties;
        this.environmentProperties = environmentProperties;
        this.order = environmentProperties.getOrder();
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public Environment findOne(String application, String profileList, String label) {
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        if (StringUtils.isEmpty((Object)application)) {
            application = defaultApplication;
        }
        if (StringUtils.isEmpty((Object)profileList)) {
            profileList = defaultProfile;
        }
        String[] profiles = StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)profileList));
        Environment environment = new Environment(application, profiles, label, null, null);
        Map<String, String> overrides = this.configServerProperties.getOverrides();
        if (!overrides.isEmpty()) {
            environment.add(new PropertySource("overrides", overrides));
        }
        for (String profile : profiles) {
            this.addPropertySource(environment, application, profile);
            if (defaultApplication.equals(application)) continue;
            this.addPropertySource(environment, defaultApplication, profile);
        }
        if (!Arrays.asList(profiles).contains(defaultProfile)) {
            this.addPropertySource(environment, application, defaultProfile);
        }
        if (!Arrays.asList(profiles).contains(defaultProfile) && !defaultApplication.equals(application)) {
            this.addPropertySource(environment, defaultApplication, defaultProfile);
        }
        if (!defaultApplication.equals(application)) {
            this.addPropertySource(environment, application, null);
        }
        this.addPropertySource(environment, defaultApplication, null);
        return environment;
    }

    private void addPropertySource(Environment environment, String application, String profile) {
        String path = this.buildPath(application, profile);
        Map<Object, Object> properties = this.findProperties(path);
        if (!properties.isEmpty()) {
            environment.add(new PropertySource(this.environmentProperties.getOrigin() + path, properties));
        }
    }

    private String buildPath(String application, String profile) {
        String prefix = this.environmentProperties.getPrefix();
        String profileSeparator = this.environmentProperties.getProfileSeparator();
        if (profile == null || profile.isEmpty()) {
            return prefix + "/" + application + "/";
        }
        return prefix + "/" + application + profileSeparator + profile + "/";
    }

    private Map<Object, Object> findProperties(String path) {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        GetSecretValueRequest request = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(path).build();
        try {
            GetSecretValueResponse response = this.awsSmClient.getSecretValue(request);
            if (response != null) {
                Map secretMap = (Map)this.objectMapper.readValue(response.secretString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                for (Map.Entry secretEntry : secretMap.entrySet()) {
                    properties.put(secretEntry.getKey(), secretEntry.getValue());
                }
            }
        }
        catch (IOException | ResourceNotFoundException e) {
            log.debug((Object)String.format("Skip adding propertySource. Unable to load secrets from AWS Secrets Manager for secretId=%s", path), e);
        }
        return properties;
    }

    public int getOrder() {
        return this.order;
    }
}

