/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.agent.model.NewService;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.discovery.AbstractDiscoveryLifecycle;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.discovery.TtlScheduler;
import org.springframework.retry.annotation.Retryable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ConsulLifecycle
extends AbstractDiscoveryLifecycle {
    private static final Logger log = LoggerFactory.getLogger(ConsulLifecycle.class);
    public static final char SEPARATOR = '-';
    private ConsulClient client;
    private ConsulDiscoveryProperties properties;
    private HeartbeatProperties ttlConfig;
    private TtlScheduler ttlScheduler;
    private ServletContext servletContext;
    private NewService service = new NewService();

    public ConsulLifecycle(ConsulClient client, ConsulDiscoveryProperties properties, HeartbeatProperties ttlConfig) {
        this.client = client;
        this.properties = properties;
        this.ttlConfig = ttlConfig;
    }

    public void setTtlScheduler(TtlScheduler ttlScheduler) {
        this.ttlScheduler = ttlScheduler;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected int getConfiguredPort() {
        return this.service.getPort() == null ? 0 : this.service.getPort();
    }

    protected void setConfiguredPort(int port) {
        this.service.setPort(Integer.valueOf(port));
    }

    public void setPort(int port) {
        this.getPort().set(port);
    }

    @Retryable(interceptor="consulRetryInterceptor")
    public void start() {
        super.start();
    }

    protected void register() {
        if (!this.properties.isRegister()) {
            log.debug("Registration disabled.");
            return;
        }
        Assert.notNull((Object)this.service.getPort(), (String)"service.port has not been set");
        String appName = this.getAppName();
        this.service.setId(this.getServiceId());
        if (!this.properties.isPreferAgentAddress()) {
            this.service.setAddress(this.properties.getHostname());
        }
        this.service.setName(ConsulLifecycle.normalizeForDns(appName));
        this.service.setTags(this.createTags());
        if (this.properties.getPort() != null) {
            this.service.setPort(this.properties.getPort());
        }
        if (this.properties.isRegisterHealthCheck()) {
            Integer checkPort = this.shouldRegisterManagement() ? this.getManagementPort() : this.service.getPort();
            this.service.setCheck(this.createCheck(checkPort));
        }
        this.register(this.service);
    }

    private NewService.Check createCheck(Integer port) {
        NewService.Check check = new NewService.Check();
        if (this.ttlConfig.isEnabled()) {
            check.setTtl(this.ttlConfig.getTtl());
            return check;
        }
        if (this.properties.getHealthCheckUrl() != null) {
            check.setHttp(this.properties.getHealthCheckUrl());
        } else {
            check.setHttp(String.format("%s://%s:%s%s", this.properties.getScheme(), this.properties.getHostname(), port, this.properties.getHealthCheckPath()));
        }
        check.setInterval(this.properties.getHealthCheckInterval());
        check.setTimeout(this.properties.getHealthCheckTimeout());
        return check;
    }

    public String getServiceId() {
        if (!StringUtils.hasText((String)this.properties.getInstanceId())) {
            return ConsulLifecycle.normalizeForDns(this.getContext().getId());
        }
        return ConsulLifecycle.normalizeForDns(this.properties.getInstanceId());
    }

    protected void registerManagement() {
        if (!this.properties.isRegister()) {
            return;
        }
        NewService management = new NewService();
        management.setId(this.getManagementServiceId());
        management.setAddress(this.properties.getHostname());
        management.setName(this.getManagementServiceName());
        management.setPort(this.getManagementPort());
        management.setTags(this.properties.getManagementTags());
        management.setCheck(this.createCheck(this.getManagementPort()));
        this.register(management);
    }

    protected void register(NewService newService) {
        log.info("Registering service with consul: {}", (Object)newService.toString());
        this.client.agentServiceRegister(newService, this.properties.getAclToken());
        if (this.ttlConfig.isEnabled() && this.ttlScheduler != null) {
            this.ttlScheduler.add(newService);
        }
    }

    protected Object getConfiguration() {
        return this.properties;
    }

    protected void deregister() {
        this.deregister(this.getServiceId());
    }

    protected void deregisterManagement() {
        this.deregister(this.getManagementServiceId());
    }

    private List<String> createTags() {
        LinkedList<String> tags = new LinkedList<String>(this.properties.getTags());
        if (this.servletContext != null && StringUtils.hasText((String)this.servletContext.getContextPath()) && StringUtils.hasText((String)this.servletContext.getContextPath().replaceAll("/", ""))) {
            tags.add("contextPath=" + this.servletContext.getContextPath());
        }
        return tags;
    }

    private void deregister(String serviceId) {
        if (!this.properties.isRegister()) {
            return;
        }
        if (this.ttlScheduler != null) {
            this.ttlScheduler.remove(serviceId);
        }
        log.info("Deregistering service with consul: {}", (Object)serviceId);
        this.client.agentServiceDeregister(serviceId);
    }

    protected boolean isEnabled() {
        return this.properties.getLifecycle().isEnabled();
    }

    protected String getAppName() {
        String appName = this.properties.getServiceName();
        return StringUtils.isEmpty((Object)appName) ? super.getAppName() : appName;
    }

    public String getManagementServiceId() {
        return ConsulLifecycle.normalizeForDns(this.getContext().getId()) + '-' + this.properties.getManagementSuffix();
    }

    public String getManagementServiceName() {
        return ConsulLifecycle.normalizeForDns(this.getAppName()) + '-' + this.properties.getManagementSuffix();
    }

    protected Integer getManagementPort() {
        if (this.properties.getManagementPort() != null) {
            return this.properties.getManagementPort();
        }
        return super.getManagementPort();
    }

    public static String normalizeForDns(String s) {
        if (s == null || !Character.isLetter(s.charAt(0)) || !Character.isLetterOrDigit(s.charAt(s.length() - 1))) {
            throw new IllegalArgumentException("Consul service ids must not be empty, must start with a letter, end with a letter or digit, and have as interior characters only letters, digits, and hyphen");
        }
        StringBuilder normalized = new StringBuilder();
        Character prev = null;
        for (char curr : s.toCharArray()) {
            Character toAppend = null;
            if (Character.isLetterOrDigit(curr)) {
                toAppend = Character.valueOf(curr);
            } else if (prev == null || prev.charValue() != '-') {
                toAppend = Character.valueOf('-');
            }
            if (toAppend == null) continue;
            normalized.append(toAppend);
            prev = toAppend;
        }
        return normalized.toString();
    }
}

