/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.agent.model.NewService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;

public class TtlScheduler {
    private static final Logger log = LoggerFactory.getLogger(TtlScheduler.class);
    private final Map<String, ScheduledFuture> serviceHeartbeats = new ConcurrentHashMap<String, ScheduledFuture>();
    private final TaskScheduler scheduler = new ConcurrentTaskScheduler(Executors.newSingleThreadScheduledExecutor());
    private HeartbeatProperties configuration;
    private ConsulClient client;

    public TtlScheduler(HeartbeatProperties configuration, ConsulClient client) {
        this.configuration = configuration;
        this.client = client;
    }

    public void add(NewService service) {
        ScheduledFuture task = this.scheduler.scheduleAtFixedRate((Runnable)new ConsulHeartbeatTask(service.getId()), this.configuration.computeHearbeatInterval().toStandardDuration().getMillis());
        ScheduledFuture previousTask = this.serviceHeartbeats.put(service.getId(), task);
        if (previousTask != null) {
            previousTask.cancel(true);
        }
    }

    public void remove(String serviceId) {
        ScheduledFuture task = this.serviceHeartbeats.get(serviceId);
        if (task != null) {
            task.cancel(true);
        }
        this.serviceHeartbeats.remove(serviceId);
    }

    private class ConsulHeartbeatTask
    implements Runnable {
        private String checkId;

        ConsulHeartbeatTask(String serviceId) {
            this.checkId = serviceId;
            if (!this.checkId.startsWith("service:")) {
                this.checkId = "service:" + this.checkId;
            }
        }

        @Override
        public void run() {
            TtlScheduler.this.client.agentCheckPass(this.checkId);
            log.debug("Sending consul heartbeat for: " + this.checkId);
        }
    }
}

