/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;

@ConfigurationProperties(value="spring.cloud.consul.discovery")
public class ConsulDiscoveryProperties {
    protected static final String MANAGEMENT = "management";
    private InetUtils.HostInfo hostInfo;
    @Value(value="${consul.token:${CONSUL_TOKEN:${spring.cloud.consul.token:${SPRING_CLOUD_CONSUL_TOKEN:}}}}")
    private String aclToken;
    private List<String> tags = new ArrayList<String>();
    private boolean enabled = true;
    private List<String> managementTags = Arrays.asList("management");
    private String healthCheckPath = "/health";
    private String healthCheckUrl;
    private String healthCheckInterval = "10s";
    private String healthCheckTimeout;
    private String healthCheckCriticalTimeout;
    private String ipAddress;
    private String hostname;
    private Integer port;
    private Integer managementPort;
    private Lifecycle lifecycle = new Lifecycle();
    private boolean preferIpAddress = false;
    private boolean preferAgentAddress = false;
    private int catalogServicesWatchDelay = 10;
    private int catalogServicesWatchTimeout = 2;
    private String serviceName;
    private String instanceId;
    private String instanceZone;
    private String instanceGroup;
    private String defaultZoneMetadataName = "zone";
    private String scheme = "http";
    private String managementSuffix = "management";
    private Map<String, String> serverListQueryTags = new HashMap<String, String>();
    private String defaultQueryTag;
    private boolean queryPassing = false;
    private boolean register = true;
    private boolean registerHealthCheck = true;
    private boolean failFast = true;

    private ConsulDiscoveryProperties() {
    }

    public ConsulDiscoveryProperties(InetUtils inetUtils) {
        this.hostInfo = inetUtils.findFirstNonLoopbackHostInfo();
        this.ipAddress = this.hostInfo.getIpAddress();
        this.hostname = this.hostInfo.getHostname();
    }

    public String getQueryTagForService(String serviceId) {
        String tag = this.serverListQueryTags.get(serviceId);
        return tag != null ? tag : this.defaultQueryTag;
    }

    public String getHostname() {
        return this.preferIpAddress ? this.ipAddress : this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
        this.hostInfo.override = true;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        this.hostInfo.override = true;
    }

    public String getAclToken() {
        return this.aclToken;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getManagementTags() {
        return this.managementTags;
    }

    public String getHealthCheckPath() {
        return this.healthCheckPath;
    }

    public String getHealthCheckUrl() {
        return this.healthCheckUrl;
    }

    public String getHealthCheckInterval() {
        return this.healthCheckInterval;
    }

    public String getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    public String getHealthCheckCriticalTimeout() {
        return this.healthCheckCriticalTimeout;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getManagementPort() {
        return this.managementPort;
    }

    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public boolean isPreferIpAddress() {
        return this.preferIpAddress;
    }

    public boolean isPreferAgentAddress() {
        return this.preferAgentAddress;
    }

    public int getCatalogServicesWatchDelay() {
        return this.catalogServicesWatchDelay;
    }

    public int getCatalogServicesWatchTimeout() {
        return this.catalogServicesWatchTimeout;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getInstanceZone() {
        return this.instanceZone;
    }

    public String getInstanceGroup() {
        return this.instanceGroup;
    }

    public String getDefaultZoneMetadataName() {
        return this.defaultZoneMetadataName;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getManagementSuffix() {
        return this.managementSuffix;
    }

    public Map<String, String> getServerListQueryTags() {
        return this.serverListQueryTags;
    }

    public String getDefaultQueryTag() {
        return this.defaultQueryTag;
    }

    public boolean isQueryPassing() {
        return this.queryPassing;
    }

    public boolean isRegister() {
        return this.register;
    }

    public boolean isRegisterHealthCheck() {
        return this.registerHealthCheck;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setAclToken(String aclToken) {
        this.aclToken = aclToken;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setManagementTags(List<String> managementTags) {
        this.managementTags = managementTags;
    }

    public void setHealthCheckPath(String healthCheckPath) {
        this.healthCheckPath = healthCheckPath;
    }

    public void setHealthCheckUrl(String healthCheckUrl) {
        this.healthCheckUrl = healthCheckUrl;
    }

    public void setHealthCheckInterval(String healthCheckInterval) {
        this.healthCheckInterval = healthCheckInterval;
    }

    public void setHealthCheckTimeout(String healthCheckTimeout) {
        this.healthCheckTimeout = healthCheckTimeout;
    }

    public void setHealthCheckCriticalTimeout(String healthCheckCriticalTimeout) {
        this.healthCheckCriticalTimeout = healthCheckCriticalTimeout;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setManagementPort(Integer managementPort) {
        this.managementPort = managementPort;
    }

    public void setLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void setPreferIpAddress(boolean preferIpAddress) {
        this.preferIpAddress = preferIpAddress;
    }

    public void setPreferAgentAddress(boolean preferAgentAddress) {
        this.preferAgentAddress = preferAgentAddress;
    }

    public void setCatalogServicesWatchDelay(int catalogServicesWatchDelay) {
        this.catalogServicesWatchDelay = catalogServicesWatchDelay;
    }

    public void setCatalogServicesWatchTimeout(int catalogServicesWatchTimeout) {
        this.catalogServicesWatchTimeout = catalogServicesWatchTimeout;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setInstanceZone(String instanceZone) {
        this.instanceZone = instanceZone;
    }

    public void setInstanceGroup(String instanceGroup) {
        this.instanceGroup = instanceGroup;
    }

    public void setDefaultZoneMetadataName(String defaultZoneMetadataName) {
        this.defaultZoneMetadataName = defaultZoneMetadataName;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setManagementSuffix(String managementSuffix) {
        this.managementSuffix = managementSuffix;
    }

    public void setServerListQueryTags(Map<String, String> serverListQueryTags) {
        this.serverListQueryTags = serverListQueryTags;
    }

    public void setDefaultQueryTag(String defaultQueryTag) {
        this.defaultQueryTag = defaultQueryTag;
    }

    public void setQueryPassing(boolean queryPassing) {
        this.queryPassing = queryPassing;
    }

    public void setRegister(boolean register) {
        this.register = register;
    }

    public void setRegisterHealthCheck(boolean registerHealthCheck) {
        this.registerHealthCheck = registerHealthCheck;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsulDiscoveryProperties)) {
            return false;
        }
        ConsulDiscoveryProperties other = (ConsulDiscoveryProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InetUtils.HostInfo this$hostInfo = this.getHostInfo();
        InetUtils.HostInfo other$hostInfo = other.getHostInfo();
        if (this$hostInfo == null ? other$hostInfo != null : !this$hostInfo.equals(other$hostInfo)) {
            return false;
        }
        String this$aclToken = this.getAclToken();
        String other$aclToken = other.getAclToken();
        if (this$aclToken == null ? other$aclToken != null : !this$aclToken.equals(other$aclToken)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        List<String> this$managementTags = this.getManagementTags();
        List<String> other$managementTags = other.getManagementTags();
        if (this$managementTags == null ? other$managementTags != null : !((Object)this$managementTags).equals(other$managementTags)) {
            return false;
        }
        String this$healthCheckPath = this.getHealthCheckPath();
        String other$healthCheckPath = other.getHealthCheckPath();
        if (this$healthCheckPath == null ? other$healthCheckPath != null : !this$healthCheckPath.equals(other$healthCheckPath)) {
            return false;
        }
        String this$healthCheckUrl = this.getHealthCheckUrl();
        String other$healthCheckUrl = other.getHealthCheckUrl();
        if (this$healthCheckUrl == null ? other$healthCheckUrl != null : !this$healthCheckUrl.equals(other$healthCheckUrl)) {
            return false;
        }
        String this$healthCheckInterval = this.getHealthCheckInterval();
        String other$healthCheckInterval = other.getHealthCheckInterval();
        if (this$healthCheckInterval == null ? other$healthCheckInterval != null : !this$healthCheckInterval.equals(other$healthCheckInterval)) {
            return false;
        }
        String this$healthCheckTimeout = this.getHealthCheckTimeout();
        String other$healthCheckTimeout = other.getHealthCheckTimeout();
        if (this$healthCheckTimeout == null ? other$healthCheckTimeout != null : !this$healthCheckTimeout.equals(other$healthCheckTimeout)) {
            return false;
        }
        String this$healthCheckCriticalTimeout = this.getHealthCheckCriticalTimeout();
        String other$healthCheckCriticalTimeout = other.getHealthCheckCriticalTimeout();
        if (this$healthCheckCriticalTimeout == null ? other$healthCheckCriticalTimeout != null : !this$healthCheckCriticalTimeout.equals(other$healthCheckCriticalTimeout)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$managementPort = this.getManagementPort();
        Integer other$managementPort = other.getManagementPort();
        if (this$managementPort == null ? other$managementPort != null : !((Object)this$managementPort).equals(other$managementPort)) {
            return false;
        }
        Lifecycle this$lifecycle = this.getLifecycle();
        Lifecycle other$lifecycle = other.getLifecycle();
        if (this$lifecycle == null ? other$lifecycle != null : !((Object)this$lifecycle).equals(other$lifecycle)) {
            return false;
        }
        if (this.isPreferIpAddress() != other.isPreferIpAddress()) {
            return false;
        }
        if (this.isPreferAgentAddress() != other.isPreferAgentAddress()) {
            return false;
        }
        if (this.getCatalogServicesWatchDelay() != other.getCatalogServicesWatchDelay()) {
            return false;
        }
        if (this.getCatalogServicesWatchTimeout() != other.getCatalogServicesWatchTimeout()) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        String this$instanceZone = this.getInstanceZone();
        String other$instanceZone = other.getInstanceZone();
        if (this$instanceZone == null ? other$instanceZone != null : !this$instanceZone.equals(other$instanceZone)) {
            return false;
        }
        String this$instanceGroup = this.getInstanceGroup();
        String other$instanceGroup = other.getInstanceGroup();
        if (this$instanceGroup == null ? other$instanceGroup != null : !this$instanceGroup.equals(other$instanceGroup)) {
            return false;
        }
        String this$defaultZoneMetadataName = this.getDefaultZoneMetadataName();
        String other$defaultZoneMetadataName = other.getDefaultZoneMetadataName();
        if (this$defaultZoneMetadataName == null ? other$defaultZoneMetadataName != null : !this$defaultZoneMetadataName.equals(other$defaultZoneMetadataName)) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        String this$managementSuffix = this.getManagementSuffix();
        String other$managementSuffix = other.getManagementSuffix();
        if (this$managementSuffix == null ? other$managementSuffix != null : !this$managementSuffix.equals(other$managementSuffix)) {
            return false;
        }
        Map<String, String> this$serverListQueryTags = this.getServerListQueryTags();
        Map<String, String> other$serverListQueryTags = other.getServerListQueryTags();
        if (this$serverListQueryTags == null ? other$serverListQueryTags != null : !((Object)this$serverListQueryTags).equals(other$serverListQueryTags)) {
            return false;
        }
        String this$defaultQueryTag = this.getDefaultQueryTag();
        String other$defaultQueryTag = other.getDefaultQueryTag();
        if (this$defaultQueryTag == null ? other$defaultQueryTag != null : !this$defaultQueryTag.equals(other$defaultQueryTag)) {
            return false;
        }
        if (this.isQueryPassing() != other.isQueryPassing()) {
            return false;
        }
        if (this.isRegister() != other.isRegister()) {
            return false;
        }
        if (this.isRegisterHealthCheck() != other.isRegisterHealthCheck()) {
            return false;
        }
        return this.isFailFast() == other.isFailFast();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsulDiscoveryProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InetUtils.HostInfo $hostInfo = this.getHostInfo();
        result = result * 59 + ($hostInfo == null ? 43 : $hostInfo.hashCode());
        String $aclToken = this.getAclToken();
        result = result * 59 + ($aclToken == null ? 43 : $aclToken.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        List<String> $managementTags = this.getManagementTags();
        result = result * 59 + ($managementTags == null ? 43 : ((Object)$managementTags).hashCode());
        String $healthCheckPath = this.getHealthCheckPath();
        result = result * 59 + ($healthCheckPath == null ? 43 : $healthCheckPath.hashCode());
        String $healthCheckUrl = this.getHealthCheckUrl();
        result = result * 59 + ($healthCheckUrl == null ? 43 : $healthCheckUrl.hashCode());
        String $healthCheckInterval = this.getHealthCheckInterval();
        result = result * 59 + ($healthCheckInterval == null ? 43 : $healthCheckInterval.hashCode());
        String $healthCheckTimeout = this.getHealthCheckTimeout();
        result = result * 59 + ($healthCheckTimeout == null ? 43 : $healthCheckTimeout.hashCode());
        String $healthCheckCriticalTimeout = this.getHealthCheckCriticalTimeout();
        result = result * 59 + ($healthCheckCriticalTimeout == null ? 43 : $healthCheckCriticalTimeout.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $managementPort = this.getManagementPort();
        result = result * 59 + ($managementPort == null ? 43 : ((Object)$managementPort).hashCode());
        Lifecycle $lifecycle = this.getLifecycle();
        result = result * 59 + ($lifecycle == null ? 43 : ((Object)$lifecycle).hashCode());
        result = result * 59 + (this.isPreferIpAddress() ? 79 : 97);
        result = result * 59 + (this.isPreferAgentAddress() ? 79 : 97);
        result = result * 59 + this.getCatalogServicesWatchDelay();
        result = result * 59 + this.getCatalogServicesWatchTimeout();
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        String $instanceZone = this.getInstanceZone();
        result = result * 59 + ($instanceZone == null ? 43 : $instanceZone.hashCode());
        String $instanceGroup = this.getInstanceGroup();
        result = result * 59 + ($instanceGroup == null ? 43 : $instanceGroup.hashCode());
        String $defaultZoneMetadataName = this.getDefaultZoneMetadataName();
        result = result * 59 + ($defaultZoneMetadataName == null ? 43 : $defaultZoneMetadataName.hashCode());
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        String $managementSuffix = this.getManagementSuffix();
        result = result * 59 + ($managementSuffix == null ? 43 : $managementSuffix.hashCode());
        Map<String, String> $serverListQueryTags = this.getServerListQueryTags();
        result = result * 59 + ($serverListQueryTags == null ? 43 : ((Object)$serverListQueryTags).hashCode());
        String $defaultQueryTag = this.getDefaultQueryTag();
        result = result * 59 + ($defaultQueryTag == null ? 43 : $defaultQueryTag.hashCode());
        result = result * 59 + (this.isQueryPassing() ? 79 : 97);
        result = result * 59 + (this.isRegister() ? 79 : 97);
        result = result * 59 + (this.isRegisterHealthCheck() ? 79 : 97);
        result = result * 59 + (this.isFailFast() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ConsulDiscoveryProperties(hostInfo=" + this.getHostInfo() + ", aclToken=" + this.getAclToken() + ", tags=" + this.getTags() + ", enabled=" + this.isEnabled() + ", managementTags=" + this.getManagementTags() + ", healthCheckPath=" + this.getHealthCheckPath() + ", healthCheckUrl=" + this.getHealthCheckUrl() + ", healthCheckInterval=" + this.getHealthCheckInterval() + ", healthCheckTimeout=" + this.getHealthCheckTimeout() + ", healthCheckCriticalTimeout=" + this.getHealthCheckCriticalTimeout() + ", ipAddress=" + this.getIpAddress() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", managementPort=" + this.getManagementPort() + ", lifecycle=" + this.getLifecycle() + ", preferIpAddress=" + this.isPreferIpAddress() + ", preferAgentAddress=" + this.isPreferAgentAddress() + ", catalogServicesWatchDelay=" + this.getCatalogServicesWatchDelay() + ", catalogServicesWatchTimeout=" + this.getCatalogServicesWatchTimeout() + ", serviceName=" + this.getServiceName() + ", instanceId=" + this.getInstanceId() + ", instanceZone=" + this.getInstanceZone() + ", instanceGroup=" + this.getInstanceGroup() + ", defaultZoneMetadataName=" + this.getDefaultZoneMetadataName() + ", scheme=" + this.getScheme() + ", managementSuffix=" + this.getManagementSuffix() + ", serverListQueryTags=" + this.getServerListQueryTags() + ", defaultQueryTag=" + this.getDefaultQueryTag() + ", queryPassing=" + this.isQueryPassing() + ", register=" + this.isRegister() + ", registerHealthCheck=" + this.isRegisterHealthCheck() + ", failFast=" + this.isFailFast() + ")";
    }

    private InetUtils.HostInfo getHostInfo() {
        return this.hostInfo;
    }

    private void setHostInfo(InetUtils.HostInfo hostInfo) {
        this.hostInfo = hostInfo;
    }

    public static class Lifecycle {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Lifecycle)) {
                return false;
            }
            Lifecycle other = (Lifecycle)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isEnabled() == other.isEnabled();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Lifecycle;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "ConsulDiscoveryProperties.Lifecycle(enabled=" + this.isEnabled() + ")";
        }
    }
}

