/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.endpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.Banner;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ConfigurationProperties(prefix="endpoints.refresh", ignoreUnknownFields=false)
@ManagedResource
public class RefreshEndpoint
extends AbstractEndpoint<Collection<String>> {
    private static final String REFRESH_ARGS_PROPERTY_SOURCE = "refreshArgs";
    private Set<String> standardSources = new HashSet<String>(Arrays.asList("systemProperties", "systemEnvironment", "jndiProperties", "servletConfigInitParams", "servletContextInitParams"));
    private ConfigurableApplicationContext context;
    private RefreshScope scope;

    public RefreshEndpoint(ConfigurableApplicationContext context, RefreshScope scope) {
        super("refresh");
        this.context = context;
        this.scope = scope;
    }

    @ManagedOperation
    public synchronized String[] refresh() {
        Map<String, Object> before = this.extract(this.context.getEnvironment().getPropertySources());
        this.addConfigFilesToEnvironment();
        Set<String> keys = this.changes(before, this.extract(this.context.getEnvironment().getPropertySources())).keySet();
        this.context.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(keys));
        this.scope.refreshAll();
        return keys.toArray(new String[keys.size()]);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void addConfigFilesToEnvironment() {
        capture = null;
        try {
            environment = this.copyEnvironment(this.context.getEnvironment());
            capture = new SpringApplicationBuilder(new Object[]{Empty.class}).bannerMode(Banner.Mode.OFF).web(false).environment((ConfigurableEnvironment)environment).run(new String[0]);
            if (environment.getPropertySources().contains("refreshArgs")) {
                environment.getPropertySources().remove("refreshArgs");
            }
            target = this.context.getEnvironment().getPropertySources();
            targetName = null;
            for (PropertySource source : environment.getPropertySources()) {
                name = source.getName();
                if (target.contains(name)) {
                    targetName = name;
                }
                if (this.standardSources.contains(name)) continue;
                if (target.contains(name)) {
                    target.replace(name, source);
                    continue;
                }
                if (targetName != null) {
                    target.addAfter(targetName, source);
                    continue;
                }
                if (target.contains("defaultProperties")) {
                    target.addBefore("defaultProperties", source);
                    continue;
                }
                target.addLast(source);
            }
        }
        finally {
            closeable /* !! */  = capture;
            ** while (closeable /* !! */  != null)
        }
lbl-1000:
        // 1 sources

        {
            closeable /* !! */ .close();
            parent = closeable /* !! */ .getParent();
            closeable /* !! */  = parent instanceof ConfigurableApplicationContext != false ? (ConfigurableApplicationContext)parent : null;
            continue;
        }
lbl34:
        // 1 sources

    }

    private StandardEnvironment copyEnvironment(ConfigurableEnvironment input) {
        StandardEnvironment environment = new StandardEnvironment();
        MutablePropertySources capturedPropertySources = environment.getPropertySources();
        for (PropertySource source : capturedPropertySources) {
            capturedPropertySources.remove(source.getName());
        }
        for (PropertySource source : input.getPropertySources()) {
            capturedPropertySources.addLast(source);
        }
        environment.setActiveProfiles(input.getActiveProfiles());
        environment.setDefaultProfiles(input.getDefaultProfiles());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spring.jmx.enabled", false);
        map.put("spring.main.sources", "");
        capturedPropertySources.addFirst((PropertySource)new MapPropertySource(REFRESH_ARGS_PROPERTY_SOURCE, map));
        return environment;
    }

    public Collection<String> invoke() {
        return Arrays.asList(this.refresh());
    }

    private Map<String, Object> changes(Map<String, Object> before, Map<String, Object> after) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : before.keySet()) {
            if (!after.containsKey(key)) {
                result.put(key, null);
                continue;
            }
            if (this.equal(before.get(key), after.get(key))) continue;
            result.put(key, after.get(key));
        }
        for (String key : after.keySet()) {
            if (before.containsKey(key)) continue;
            result.put(key, after.get(key));
        }
        return result;
    }

    private boolean equal(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        return one.equals(two);
    }

    private Map<String, Object> extract(MutablePropertySources propertySources) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<PropertySource> sources = new ArrayList<PropertySource>();
        for (PropertySource source : propertySources) {
            sources.add(0, source);
        }
        for (PropertySource source : sources) {
            if (this.standardSources.contains(source.getName())) continue;
            this.extract(source, result);
        }
        return result;
    }

    private void extract(PropertySource<?> parent, Map<String, Object> result) {
        if (parent instanceof CompositePropertySource) {
            try {
                ArrayList<PropertySource> sources = new ArrayList<PropertySource>();
                for (PropertySource source : ((CompositePropertySource)parent).getPropertySources()) {
                    sources.add(0, source);
                }
                for (PropertySource source : sources) {
                    this.extract(source, result);
                }
            }
            catch (Exception e) {
                return;
            }
        } else if (parent instanceof EnumerablePropertySource) {
            String[] stringArray = ((EnumerablePropertySource)parent).getPropertyNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                result.put(key, parent.getProperty(key));
                ++n2;
            }
        }
    }

    @Configuration
    protected static class Empty {
        protected Empty() {
        }
    }
}

