/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.ParentContextApplicationContextInitializer;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.cloud.bootstrap.BootstrapConfiguration;
import org.springframework.cloud.bootstrap.encrypt.EnvironmentDecryptApplicationInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class BootstrapApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    public static final String BOOTSTRAP_PROPERTY_SOURCE_NAME = "bootstrap";
    public static final int DEFAULT_ORDER = -2147483643;
    public static final String DEFAULT_PROPERTIES = "defaultProperties";
    private int order = -2147483643;

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        if (!((Boolean)environment.getProperty("spring.cloud.bootstrap.enabled", Boolean.class, (Object)true)).booleanValue()) {
            return;
        }
        if (environment.getPropertySources().contains(BOOTSTRAP_PROPERTY_SOURCE_NAME)) {
            return;
        }
        ConfigurableApplicationContext context = null;
        String configName = environment.resolvePlaceholders("${spring.cloud.bootstrap.name:bootstrap}");
        for (ApplicationContextInitializer initializer : event.getSpringApplication().getInitializers()) {
            if (!(initializer instanceof ParentContextApplicationContextInitializer)) continue;
            context = this.findBootstrapContext((ParentContextApplicationContextInitializer)initializer, configName);
        }
        if (context == null) {
            context = this.bootstrapServiceContext(environment, event.getSpringApplication(), configName);
        }
        this.apply(context, event.getSpringApplication(), environment);
    }

    private ConfigurableApplicationContext findBootstrapContext(ParentContextApplicationContextInitializer initializer, String configName) {
        Field field = ReflectionUtils.findField(ParentContextApplicationContextInitializer.class, (String)"parent");
        ReflectionUtils.makeAccessible((Field)field);
        ConfigurableApplicationContext parent = this.safeCast(ConfigurableApplicationContext.class, ReflectionUtils.getField((Field)field, (Object)initializer));
        if (parent != null && !configName.equals(parent.getId())) {
            parent = this.safeCast(ConfigurableApplicationContext.class, parent.getParent());
        }
        return parent;
    }

    private <T> T safeCast(Class<T> type, Object object) {
        try {
            return type.cast(object);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private ConfigurableApplicationContext bootstrapServiceContext(ConfigurableEnvironment environment, SpringApplication application, String configName) {
        StandardEnvironment bootstrapEnvironment = new StandardEnvironment();
        MutablePropertySources bootstrapProperties = bootstrapEnvironment.getPropertySources();
        for (PropertySource source : bootstrapProperties) {
            bootstrapProperties.remove(source.getName());
        }
        String configLocation = environment.resolvePlaceholders("${spring.cloud.bootstrap.location:}");
        HashMap<String, String> bootstrapMap = new HashMap<String, String>();
        bootstrapMap.put("spring.config.name", configName);
        if (StringUtils.hasText((String)configLocation)) {
            bootstrapMap.put("spring.config.location", configLocation);
        }
        bootstrapProperties.addFirst((PropertySource)new MapPropertySource(BOOTSTRAP_PROPERTY_SOURCE_NAME, bootstrapMap));
        for (PropertySource source : environment.getPropertySources()) {
            bootstrapProperties.addLast(source);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        List names = SpringFactoriesLoader.loadFactoryNames(BootstrapConfiguration.class, (ClassLoader)classLoader);
        for (String name : StringUtils.commaDelimitedListToStringArray((String)environment.getProperty("spring.cloud.bootstrap.sources", ""))) {
            names.add(name);
        }
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[0]).profiles(environment.getActiveProfiles()).bannerMode(Banner.Mode.OFF).environment((ConfigurableEnvironment)bootstrapEnvironment).registerShutdownHook(false).logStartupInfo(false).web(WebApplicationType.NONE);
        ArrayList<Class> sources = new ArrayList<Class>();
        for (String name : names) {
            Class cls = ClassUtils.resolveClassName((String)name, null);
            try {
                cls.getDeclaredAnnotations();
            }
            catch (Exception e) {
                continue;
            }
            sources.add(cls);
        }
        AnnotationAwareOrderComparator.sort(sources);
        builder.sources(sources.toArray(new Class[sources.size()]));
        ConfigurableApplicationContext context = builder.run(new String[0]);
        context.setId(BOOTSTRAP_PROPERTY_SOURCE_NAME);
        this.addAncestorInitializer(application, context);
        bootstrapProperties.remove(BOOTSTRAP_PROPERTY_SOURCE_NAME);
        this.mergeDefaultProperties(environment.getPropertySources(), bootstrapProperties);
        return context;
    }

    private void mergeDefaultProperties(MutablePropertySources environment, MutablePropertySources bootstrap) {
        String name = DEFAULT_PROPERTIES;
        if (!bootstrap.contains(name)) {
            return;
        }
        PropertySource source = bootstrap.get(name);
        if (!environment.contains(name)) {
            environment.addLast(source);
        } else {
            PropertySource target = environment.get(name);
            if (target instanceof MapPropertySource) {
                Map targetMap = (Map)((MapPropertySource)target).getSource();
                if (target == source) {
                    return;
                }
                if (source instanceof MapPropertySource) {
                    Map map = (Map)((MapPropertySource)source).getSource();
                    for (String key : map.keySet()) {
                        if (target.containsProperty(key)) continue;
                        targetMap.put(key, map.get(key));
                    }
                }
            }
        }
        this.mergeAdditionalPropertySources(environment, bootstrap);
    }

    private void mergeAdditionalPropertySources(MutablePropertySources environment, MutablePropertySources bootstrap) {
        PropertySource defaultProperties = environment.get(DEFAULT_PROPERTIES);
        ExtendedDefaultPropertySource result = defaultProperties instanceof ExtendedDefaultPropertySource ? (ExtendedDefaultPropertySource)defaultProperties : new ExtendedDefaultPropertySource(defaultProperties.getName(), defaultProperties);
        for (PropertySource source : bootstrap) {
            if (environment.contains(source.getName())) continue;
            result.add(source);
        }
        for (String name : result.getPropertySourceNames()) {
            bootstrap.remove(name);
        }
        environment.replace(DEFAULT_PROPERTIES, (PropertySource)result);
        bootstrap.replace(DEFAULT_PROPERTIES, (PropertySource)result);
    }

    private void addAncestorInitializer(SpringApplication application, ConfigurableApplicationContext context) {
        boolean installed = false;
        for (ApplicationContextInitializer initializer : application.getInitializers()) {
            if (!(initializer instanceof AncestorInitializer)) continue;
            installed = true;
            ((AncestorInitializer)initializer).setParent(context);
        }
        if (!installed) {
            application.addInitializers(new ApplicationContextInitializer[]{new AncestorInitializer(context)});
        }
    }

    private void apply(ConfigurableApplicationContext context, SpringApplication application, ConfigurableEnvironment environment) {
        List<ApplicationContextInitializer> initializers = this.getOrderedBeansOfType((ListableBeanFactory)context, ApplicationContextInitializer.class);
        application.addInitializers(initializers.toArray(new ApplicationContextInitializer[initializers.size()]));
        this.addBootstrapDecryptInitializer(application);
    }

    private void addBootstrapDecryptInitializer(SpringApplication application) {
        DelegatingEnvironmentDecryptApplicationInitializer decrypter = null;
        for (ApplicationContextInitializer initializer : application.getInitializers()) {
            if (!(initializer instanceof EnvironmentDecryptApplicationInitializer)) continue;
            ApplicationContextInitializer delegate = initializer;
            decrypter = new DelegatingEnvironmentDecryptApplicationInitializer((ApplicationContextInitializer<ConfigurableApplicationContext>)delegate);
        }
        if (decrypter != null) {
            application.addInitializers(new ApplicationContextInitializer[]{decrypter});
        }
    }

    private <T> List<T> getOrderedBeansOfType(ListableBeanFactory context, Class<T> type) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String name : context.getBeanNamesForType(type)) {
            result.add(context.getBean(name, type));
        }
        AnnotationAwareOrderComparator.sort(result);
        return result;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    private static class ExtendedDefaultPropertySource
    extends SystemEnvironmentPropertySource {
        private final CompositePropertySource sources;
        private final List<String> names = new ArrayList<String>();

        public ExtendedDefaultPropertySource(String name, PropertySource<?> propertySource) {
            super(name, ExtendedDefaultPropertySource.findMap(propertySource));
            this.sources = new CompositePropertySource(name);
        }

        public CompositePropertySource getPropertySources() {
            return this.sources;
        }

        public List<String> getPropertySourceNames() {
            return this.names;
        }

        public void add(PropertySource<?> source) {
            if (source instanceof EnumerablePropertySource && !this.names.contains(source.getName())) {
                this.sources.addPropertySource(source);
                this.names.add(source.getName());
            }
        }

        public Object getProperty(String name) {
            if (this.sources.containsProperty(name)) {
                return this.sources.getProperty(name);
            }
            return super.getProperty(name);
        }

        public boolean containsProperty(String name) {
            if (this.sources.containsProperty(name)) {
                return true;
            }
            return super.containsProperty(name);
        }

        public String[] getPropertyNames() {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(Arrays.asList(this.sources.getPropertyNames()));
            names.addAll(Arrays.asList(super.getPropertyNames()));
            return names.toArray(new String[0]);
        }

        private static Map<String, Object> findMap(PropertySource<?> propertySource) {
            if (propertySource instanceof MapPropertySource) {
                return (Map)propertySource.getSource();
            }
            return new LinkedHashMap<String, Object>();
        }
    }

    @Order(value=-2147483639)
    private static class DelegatingEnvironmentDecryptApplicationInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private ApplicationContextInitializer<ConfigurableApplicationContext> delegate;

        public DelegatingEnvironmentDecryptApplicationInitializer(ApplicationContextInitializer<ConfigurableApplicationContext> delegate) {
            this.delegate = delegate;
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            this.delegate.initialize(applicationContext);
        }
    }

    private static class AncestorInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext>,
    Ordered {
        private ConfigurableApplicationContext parent;

        public AncestorInitializer(ConfigurableApplicationContext parent) {
            this.parent = parent;
        }

        public void setParent(ConfigurableApplicationContext parent) {
            this.parent = parent;
        }

        public int getOrder() {
            return -2147483643;
        }

        public void initialize(ConfigurableApplicationContext context) {
            while (context.getParent() != null && context.getParent() != context) {
                context = (ConfigurableApplicationContext)context.getParent();
            }
            this.reorderSources(context.getEnvironment());
            new ParentContextApplicationContextInitializer((ApplicationContext)this.parent).initialize(context);
        }

        private void reorderSources(ConfigurableEnvironment environment) {
            PropertySource removed = environment.getPropertySources().remove(BootstrapApplicationListener.DEFAULT_PROPERTIES);
            if (removed instanceof ExtendedDefaultPropertySource) {
                ExtendedDefaultPropertySource defaultProperties = (ExtendedDefaultPropertySource)removed;
                environment.getPropertySources().addLast((PropertySource)new MapPropertySource(BootstrapApplicationListener.DEFAULT_PROPERTIES, (Map)defaultProperties.getSource()));
                for (PropertySource source : defaultProperties.getPropertySources().getPropertySources()) {
                    if (environment.getPropertySources().contains(source.getName())) continue;
                    environment.getPropertySources().addBefore(BootstrapApplicationListener.DEFAULT_PROPERTIES, source);
                }
            }
        }
    }
}

