/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.wiremock;

import com.google.common.collect.ListMultimap;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.converter.SingleFileConverter;
import org.springframework.cloud.contract.verifier.file.ContractFileScanner;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.wiremock.ConversionContractVerifierException;

public class RecursiveFilesConverter
implements GroovyObject {
    private final SingleFileConverter singleFileConverter;
    private final ContractVerifierConfigProperties properties;
    private final File outMappingsDir;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    /*
     * WARNING - void declaration
     */
    public RecursiveFilesConverter(SingleFileConverter singleFileConverter, ContractVerifierConfigProperties contractVerifierConfigProperties) {
        File file;
        void singleFileConverter2;
        void properties;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var4_4 = properties;
        this.properties = var4_4;
        void var5_5 = singleFileConverter2;
        this.singleFileConverter = var5_5;
        this.outMappingsDir = file = properties.getStubsOutputDir();
    }

    /*
     * WARNING - void declaration
     */
    public RecursiveFilesConverter(SingleFileConverter singleFileConverter, ContractVerifierConfigProperties contractVerifierConfigProperties, File file) {
        void outMappingsDir;
        void singleFileConverter2;
        void properties;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var5_5 = properties;
        this.properties = var5_5;
        void var6_6 = singleFileConverter2;
        this.singleFileConverter = var6_6;
        void var7_7 = outMappingsDir;
        this.outMappingsDir = var7_7;
    }

    public void processFiles() {
        ContractFileScanner scanner = new ContractFileScanner(this.properties.getContractsDslDir(), (Set)ScriptBytecodeAdapter.asType((Object)this.properties.getExcludedFiles(), Set.class), (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class), this.properties.getIncludedContracts());
        ListMultimap contracts = scanner.findContracts();
        if (log.isDebugEnabled()) {
            Object v1;
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{contracts}, new String[]{"Found the following contracts ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.properties.isExcludeBuildFolders()}, new String[]{"Exclude build folder: [", "]"})));
                v1 = null;
            } else {
                v1 = null;
            }
        }
        public class _processFiles_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processFiles_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object entry) {
                Reference entry2 = new Reference(entry);
                public class _closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference entry;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure2(Object _outerInstance, Object _thisObject, Reference entry) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.entry = reference = entry;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public Object doCall(ContractMetadata contract) {
                        sourceFile = contract.getPath().toFile();
                        path = sourceFile.getPath();
                        if (!(RecursiveFilesConverter.pfaccess$1((RecursiveFilesConverter)this.getThisObject()).isExcludeBuildFolders() != false && (RecursiveFilesConverter.access$2((RecursiveFilesConverter)this.getThisObject(), path, "target") != false || RecursiveFilesConverter.access$2((RecursiveFilesConverter)this.getThisObject(), path, "build") != false) != false)) ** GOTO lbl18
                        if (RecursiveFilesConverter.pfaccess$2(null).isDebugEnabled()) {
                            if (RecursiveFilesConverter.pfaccess$2(null).isDebugEnabled()) {
                                RecursiveFilesConverter.pfaccess$2(null).debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path}, new String[]{"Exclude build folder is set. Path [", "] contains [target] or [build] in its path"})));
                                v0 = null;
                            } else {
                                v0 = null;
                            }
                        }
                        var4_4 = null;
                        return var4_4;
lbl18:
                        // 1 sources

                        if (!(RecursiveFilesConverter.pfaccess$0((RecursiveFilesConverter)this.getThisObject()).canHandleFileName(sourceFile.getName()) == false)) ** GOTO lbl24
                        var5_5 = null;
                        return var5_5;
lbl24:
                        // 1 sources

                        convertedContent = RecursiveFilesConverter.pfaccess$0((RecursiveFilesConverter)this.getThisObject()).convertContent(((Path)DefaultGroovyMethods.last((Iterable)((Iterable)ScriptBytecodeAdapter.castToType(((Map.Entry)this.entry.get()).getKey(), Iterable.class)))).toString(), contract);
                        if (!(DefaultTypeTransformation.booleanUnbox((Object)convertedContent) == false)) ** GOTO lbl32
                        var7_7 = null;
                        return var7_7;
lbl32:
                        // 1 sources

                        absoluteTargetPath = RecursiveFilesConverter.access$0((RecursiveFilesConverter)this.getThisObject(), sourceFile);
                        newJsonFile = RecursiveFilesConverter.access$1((RecursiveFilesConverter)this.getThisObject(), absoluteTargetPath, sourceFile);
                        ResourceGroovyMethods.setText((File)newJsonFile, (String)convertedContent, (String)StandardCharsets.UTF_8.toString());
                        var10_10 = null;
                        try {
                            return var10_10;
                        }
                        catch (Exception e) {
                            throw (Throwable)new ConversionContractVerifierException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{sourceFile.getName()}, new String[]{"Unable to make conversion of ", ""})), e);
                        }
                    }

                    public Object call(ContractMetadata contract) {
                        return this.doCall(contract);
                    }

                    public Object getEntry() {
                        return this.entry.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.each((Collection)((Collection)ScriptBytecodeAdapter.castToType(((Map.Entry)entry2.get()).getValue(), Collection.class)), (Closure)new _closure2((Object)this, this.getThisObject(), entry2));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processFiles_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(contracts.asMap().entrySet(), (Closure)new _processFiles_closure1(this, this));
    }

    private boolean matchesPath(String path, String folder) {
        return path.matches(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{File.separator, folder, File.separator}, new String[]{"^.*", "", "", ".*$"})));
    }

    private Path createAndReturnTargetDirectory(File sourceFile) {
        Path relativePath = Paths.get(this.properties.getContractsDslDir().toURI()).relativize(sourceFile.getParentFile().toPath());
        Path absoluteTargetPath = this.outMappingsDir.toPath().resolve(relativePath);
        Files.createDirectories(absoluteTargetPath, new FileAttribute[0]);
        return absoluteTargetPath;
    }

    private File createTargetFileWithProperName(Path absoluteTargetPath, File sourceFile) {
        Object v0;
        File newJsonFile = new File(absoluteTargetPath.toFile(), this.singleFileConverter.generateOutputFileNameForInput(sourceFile.getName()));
        if (log.isInfoEnabled()) {
            log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{newJsonFile.getPath()}, new String[]{"Creating new json [", "]"})));
            v0 = null;
        } else {
            v0 = null;
        }
        return newJsonFile;
    }

    public static /* synthetic */ Path access$0(RecursiveFilesConverter $that, File sourceFile) {
        return $that.createAndReturnTargetDirectory(sourceFile);
    }

    public static /* synthetic */ File access$1(RecursiveFilesConverter $that, Path absoluteTargetPath, File sourceFile) {
        return $that.createTargetFileWithProperName(absoluteTargetPath, sourceFile);
    }

    public static /* synthetic */ boolean access$2(RecursiveFilesConverter $that, String path, String folder) {
        return $that.matchesPath(path, folder);
    }

    public static /* synthetic */ SingleFileConverter pfaccess$0(RecursiveFilesConverter $that) {
        return $that.singleFileConverter;
    }

    public static /* synthetic */ ContractVerifierConfigProperties pfaccess$1(RecursiveFilesConverter $that) {
        return $that.properties;
    }

    public static /* synthetic */ Logger pfaccess$2(RecursiveFilesConverter $that) {
        return log;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RecursiveFilesConverter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"org.springframework.cloud.contract.verifier.wiremock.RecursiveFilesConverter");
    }
}

