/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;

class CopyContracts {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String CONTRACTS_PATH = "/contracts";
    private final MavenProject project;
    private final MavenSession mavenSession;
    private final MavenResourcesFiltering mavenResourcesFiltering;
    private final ContractVerifierConfigProperties config;

    CopyContracts(MavenProject project, MavenSession mavenSession, MavenResourcesFiltering mavenResourcesFiltering, ContractVerifierConfigProperties config) {
        this.project = project;
        this.mavenSession = mavenSession;
        this.mavenResourcesFiltering = mavenResourcesFiltering;
        this.config = config;
    }

    public void copy(File contractsDirectory, File outputDirectory, String rootPath) throws MojoExecutionException {
        File outputFolderWithContracts = outputDirectory.getPath().endsWith("contracts") ? outputDirectory : new File(outputDirectory, rootPath + CONTRACTS_PATH);
        log.info("Copying Spring Cloud Contract Verifier contracts to [" + outputFolderWithContracts + "]. Only files matching [" + this.config.getIncludedContracts() + "] pattern will end up in the final JAR with stubs.");
        Resource resource = new Resource();
        String includedRootFolderAntPattern = this.config.getIncludedRootFolderAntPattern() + "*.*";
        String slashSeparatedGroupIdAntPattern = this.slashSeparatedGroupIdAntPattern(includedRootFolderAntPattern);
        String dotSeparatedGroupIdAntPattern = this.dotSeparatedGroupIdAntPattern(includedRootFolderAntPattern);
        resource.addInclude(slashSeparatedGroupIdAntPattern);
        if (!slashSeparatedGroupIdAntPattern.equals(dotSeparatedGroupIdAntPattern)) {
            resource.addInclude(dotSeparatedGroupIdAntPattern);
        }
        if (this.config.isExcludeBuildFolders()) {
            resource.addExclude("**/target/**");
            resource.addExclude("**/build/**");
        }
        resource.setDirectory(contractsDirectory.getAbsolutePath());
        MavenResourcesExecution execution = new MavenResourcesExecution();
        execution.setResources(Collections.singletonList(resource));
        execution.setOutputDirectory(outputFolderWithContracts);
        execution.setMavenProject(this.project);
        execution.setEncoding("UTF-8");
        execution.setMavenSession(this.mavenSession);
        execution.setInjectProjectBuildFilters(false);
        execution.setOverwrite(true);
        execution.setIncludeEmptyDirs(false);
        execution.setFilterFilenames(false);
        try {
            this.mavenResourcesFiltering.filterResources(execution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private String slashSeparatedGroupIdAntPattern(String includedRootFolderAntPattern) {
        if (includedRootFolderAntPattern.contains(this.slashSeparatedGroupId())) {
            return includedRootFolderAntPattern;
        }
        if (includedRootFolderAntPattern.contains(this.dotSeparatedGroupId())) {
            return includedRootFolderAntPattern.replace(this.dotSeparatedGroupId(), this.slashSeparatedGroupId());
        }
        return includedRootFolderAntPattern;
    }

    private String dotSeparatedGroupIdAntPattern(String includedRootFolderAntPattern) {
        if (includedRootFolderAntPattern.contains(this.dotSeparatedGroupId())) {
            return includedRootFolderAntPattern;
        }
        if (includedRootFolderAntPattern.contains(this.slashSeparatedGroupId())) {
            return includedRootFolderAntPattern.replace(this.slashSeparatedGroupId(), this.dotSeparatedGroupId());
        }
        return includedRootFolderAntPattern;
    }

    private String slashSeparatedGroupId() {
        return this.project.getGroupId().replace(".", File.separator);
    }

    private String dotSeparatedGroupId() {
        return this.project.getGroupId();
    }
}

