/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.eclipse.aether.RepositorySystemSession;
import org.springframework.cloud.contract.maven.verifier.CopyContracts;
import org.springframework.cloud.contract.maven.verifier.MavenContractsDownloader;
import org.springframework.cloud.contract.maven.verifier.stubrunner.AetherStubDownloaderFactory;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.converter.RecursiveFilesConverter;

@Mojo(name="convert", requiresProject=false, defaultPhase=LifecyclePhase.PROCESS_TEST_RESOURCES)
public class ConvertMojo
extends AbstractMojo {
    static final String DEFAULT_STUBS_DIR = "${project.build.directory}/stubs/";
    static final String MAPPINGS_PATH = "/mappings";
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(property="spring.cloud.contract.verifier.contractsDirectory", defaultValue="${project.basedir}/src/test/resources/contracts")
    private File contractsDirectory;
    @Parameter(defaultValue="${project.build.directory}/stubs/")
    private File stubsDirectory;
    @Parameter(property="contractsDirectory", defaultValue="${basedir}")
    private File source;
    @Parameter(property="stubsDirectory", defaultValue="${basedir}")
    private File destination;
    @Parameter(property="spring.cloud.contract.verifier.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="contractsRepositoryUrl")
    private String contractsRepositoryUrl;
    @Parameter(property="contractDependency")
    private Dependency contractDependency;
    @Parameter(property="contractsPath")
    private String contractsPath;
    @Parameter(property="contractsMode", defaultValue="CLASSPATH")
    private StubRunnerProperties.StubsMode contractsMode;
    @Parameter(property="excludeBuildFolders", defaultValue="false")
    private boolean excludeBuildFolders;
    @Parameter(property="contractsRepositoryUsername")
    private String contractsRepositoryUsername;
    @Parameter(property="contractsRepositoryPassword")
    private String contractsRepositoryPassword;
    @Parameter(property="contractsRepositoryProxyHost")
    private String contractsRepositoryProxyHost;
    @Parameter(property="contractsRepositoryProxyPort")
    private Integer contractsRepositoryProxyPort;
    @Deprecated
    @Parameter(property="contractsSnapshotCheckSkip", defaultValue="false")
    private boolean contractsSnapshotCheckSkip;
    @Parameter(property="deleteStubsAfterTest", defaultValue="true")
    private boolean deleteStubsAfterTest;
    @Parameter(property="contractsProperties")
    private Map<String, String> contractsProperties = new HashMap<String, String>();
    @Component(role=MavenResourcesFiltering.class, hint="default")
    private MavenResourcesFiltering mavenResourcesFiltering;
    private final AetherStubDownloaderFactory aetherStubDownloaderFactory;

    @Inject
    public ConvertMojo(AetherStubDownloaderFactory aetherStubDownloaderFactory) {
        this.aetherStubDownloaderFactory = aetherStubDownloaderFactory;
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)String.format("Skipping Spring Cloud Contract Verifier execution: spring.cloud.contract.verifier.skip=%s", this.skip));
            return;
        }
        String groupId = this.project.getGroupId();
        String artifactId = this.project.getArtifactId();
        String version = this.project.getVersion();
        String rootPath = "META-INF/" + groupId + "/" + artifactId + "/" + version;
        ContractVerifierConfigProperties config = new ContractVerifierConfigProperties();
        config.setExcludeBuildFolders(this.excludeBuildFolders);
        File contractsDirectory = this.locationOfContracts(config);
        this.getLog().info((CharSequence)("Directory with contract is present at [" + contractsDirectory + "]"));
        contractsDirectory = this.contractSubfolderIfPresent(contractsDirectory);
        new CopyContracts(this.project, this.mavenSession, this.mavenResourcesFiltering, config).copy(contractsDirectory, this.stubsDirectory, rootPath);
        File contractsDslDir = this.contractsDslDir(contractsDirectory);
        config.setContractsDslDir(contractsDslDir);
        config.setStubsOutputDir(this.stubsOutputDir(rootPath));
        this.logSetup(config, contractsDslDir);
        RecursiveFilesConverter converter = new RecursiveFilesConverter(config);
        converter.processFiles();
    }

    private void logSetup(ContractVerifierConfigProperties config, File contractsDslDir) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("The contracts dir equals [" + contractsDslDir + "]"));
        }
        this.getLog().info((CharSequence)"Converting from Spring Cloud Contract Verifier contracts to WireMock stubs mappings");
        this.getLog().info((CharSequence)String.format("     Spring Cloud Contract Verifier contracts directory: %s", config.getContractsDslDir()));
        this.getLog().info((CharSequence)String.format("Stub Server stubs mappings directory: %s", config.getStubsOutputDir()));
    }

    private File contractSubfolderIfPresent(File contractsDirectory) {
        File contractsSubFolder = new File(contractsDirectory, "contracts");
        if (contractsSubFolder.exists()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"The subfolder [contracts] exists, will pick it as a source of contracts");
            }
            contractsDirectory = contractsSubFolder;
        }
        return contractsDirectory;
    }

    private File locationOfContracts(ContractVerifierConfigProperties config) {
        return new MavenContractsDownloader(this.project, this.contractDependency, this.contractsPath, this.contractsRepositoryUrl, this.contractsMode, this.getLog(), this.contractsRepositoryUsername, this.contractsRepositoryPassword, this.contractsRepositoryProxyHost, this.contractsRepositoryProxyPort, this.deleteStubsAfterTest, this.contractsProperties).downloadAndUnpackContractsIfRequired(config, this.contractsDirectory);
    }

    private File stubsOutputDir(String rootPath) {
        return this.isInsideProject() ? new File(this.stubsDirectory, rootPath + MAPPINGS_PATH) : this.destination;
    }

    private File contractsDslDir(File contractsDirectory) {
        return this.isInsideProject() ? contractsDirectory : this.source;
    }

    private boolean isInsideProject() {
        return this.mavenSession.getRequest().isProjectPresent();
    }
}

