/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl.synccontext;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapter;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactory;
import shaded.org.eclipse.aether.spi.locator.Service;
import shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import shaded.org.eclipse.aether.spi.synccontext.SyncContextFactory;

@Singleton
@Named
public final class DefaultSyncContextFactory
implements SyncContextFactory,
Service {
    private static final String ADAPTER_KEY = DefaultSyncContextFactory.class.getName() + ".adapter";
    private NamedLockFactoryAdapterFactory namedLockFactoryAdapterFactory;

    @Inject
    public DefaultSyncContextFactory(NamedLockFactoryAdapterFactory namedLockFactoryAdapterFactory) {
        this.namedLockFactoryAdapterFactory = Objects.requireNonNull(namedLockFactoryAdapterFactory);
    }

    @Deprecated
    public DefaultSyncContextFactory() {
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.namedLockFactoryAdapterFactory = Objects.requireNonNull(locator.getService(NamedLockFactoryAdapterFactory.class));
    }

    @Override
    public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
        Objects.requireNonNull(session, "session cannot be null");
        NamedLockFactoryAdapter adapter = (NamedLockFactoryAdapter)session.getData().computeIfAbsent(ADAPTER_KEY, () -> this.namedLockFactoryAdapterFactory.getAdapter(session));
        return adapter.newInstance(session, shared);
    }
}

