/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.Objects;
import org.springframework.cloud.contract.spec.internal.ContractUtils;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;

public class Cookie
extends DslProperty {
    private String key;

    public Cookie(String key, DslProperty dslProperty) {
        super(dslProperty.getClientValue(), dslProperty.getServerValue());
        this.key = key;
    }

    public Cookie(String key, MatchingStrategy value) {
        super(value);
        this.key = key;
    }

    public Cookie(String key, Object value) {
        super(ContractUtils.CLIENT_VALUE.apply(value), ContractUtils.SERVER_VALUE.apply(value));
        this.key = key;
    }

    public static Cookie build(String key, Object value) {
        if (value instanceof MatchingStrategy) {
            return new Cookie(key, (MatchingStrategy)value);
        }
        return new Cookie(key, value);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        return Objects.equals(this.key, cookie.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.key);
    }

    @Override
    public String toString() {
        return "Cookie{key='" + this.key + '\'' + "}, value=" + super.toString();
    }
}

