/*
 * Copyright 2013-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.contract.spec.internal

import groovy.transform.CompileStatic
import groovy.transform.EqualsAndHashCode
import groovy.transform.ToString

/**
 * Contains Http Methods
 *
 * @author Marcin Grzejszczak
 * @since 1.0.2
 */
@CompileStatic
@EqualsAndHashCode(includeFields = true)
@ToString(includePackage = false)
class HttpMethods {

	HttpMethod GET() {
		return HttpMethod.GET
	}

	HttpMethod HEAD() {
		return HttpMethod.HEAD
	}

	HttpMethod POST() {
		return HttpMethod.POST
	}

	HttpMethod PUT() {
		return HttpMethod.PUT
	}

	HttpMethod PATCH() {
		return HttpMethod.PATCH
	}

	HttpMethod DELETE() {
		return HttpMethod.DELETE
	}

	HttpMethod OPTIONS() {
		return HttpMethod.OPTIONS
	}

	HttpMethod TRACE() {
		return HttpMethod.TRACE
	}

	enum HttpMethod {
		GET, HEAD, POST, PUT, PATCH, DELETE, OPTIONS, TRACE
	}
}
