/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.springframework.util.StringUtils;

class AetherFactories {
    private static final String MAVEN_LOCAL_REPOSITORY_LOCATION = "maven.repo.local";

    AetherFactories() {
    }

    public static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public static RepositorySystemSession newSession(RepositorySystem system, boolean workOffline) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setOffline(workOffline);
        if (!workOffline) {
            session.setUpdatePolicy("always");
        }
        LocalRepository localRepo = new LocalRepository(AetherFactories.localRepositoryDirectory());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        return session;
    }

    public static List<RemoteRepository> newRepositories(List<String> repositories) {
        ArrayList<RemoteRepository> result = new ArrayList<RemoteRepository>();
        for (int index = 0; index < repositories.size(); ++index) {
            String repo = repositories.get(index);
            if (!StringUtils.hasText((String)repo)) continue;
            result.add(new RemoteRepository.Builder("remote" + index, "default", repo).build());
        }
        return result;
    }

    private static String localRepositoryDirectory() {
        return System.getProperty(MAVEN_LOCAL_REPOSITORY_LOCATION, System.getProperty("user.home") + "/.m2/repository");
    }
}

