/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.WiremockMappingDescriptor;
import org.springframework.cloud.contract.verifier.util.ContractVerifierDslConverter;

class StubRepository {
    private static final Logger log = LoggerFactory.getLogger(StubRepository.class);
    private final File path;
    final List<WiremockMappingDescriptor> projectDescriptors;
    final Collection<Contract> contracts;

    public StubRepository(File repository) {
        if (!repository.isDirectory()) {
            throw new IllegalArgumentException("Missing descriptor repository under path [" + repository + "]");
        }
        this.path = repository;
        this.projectDescriptors = this.projectDescriptors();
        this.contracts = this.contracts();
    }

    public File getPath() {
        return this.path;
    }

    public List<WiremockMappingDescriptor> getProjectDescriptors() {
        return this.projectDescriptors;
    }

    public Collection<Contract> getContracts() {
        return this.contracts;
    }

    private Collection<Contract> contracts() {
        ArrayList<Contract> contracts = new ArrayList<Contract>();
        contracts.addAll(this.contractDescriptors());
        return contracts;
    }

    private List<WiremockMappingDescriptor> projectDescriptors() {
        ArrayList<WiremockMappingDescriptor> mappingDescriptors = new ArrayList<WiremockMappingDescriptor>();
        mappingDescriptors.addAll(this.contextDescriptors());
        return mappingDescriptors;
    }

    private List<WiremockMappingDescriptor> contextDescriptors() {
        return this.path.exists() ? this.collectMappingDescriptors(this.path) : Collections.emptyList();
    }

    private List<WiremockMappingDescriptor> collectMappingDescriptors(File descriptorsDirectory) {
        final ArrayList<WiremockMappingDescriptor> mappingDescriptors = new ArrayList<WiremockMappingDescriptor>();
        try {
            Files.walkFileTree(Paths.get(descriptorsDirectory.toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    File file = path.toFile();
                    if (StubRepository.isMappingDescriptor(file)) {
                        mappingDescriptors.add(new WiremockMappingDescriptor(file));
                    }
                    return super.visitFile(path, attrs);
                }
            });
        }
        catch (IOException e) {
            log.warn("Exception occurred while trying to parse file", (Throwable)e);
        }
        return mappingDescriptors;
    }

    private Collection<Contract> contractDescriptors() {
        return this.path.exists() ? this.collectContractDescriptors(this.path) : Collections.emptySet();
    }

    private Collection<Contract> collectContractDescriptors(File descriptorsDirectory) {
        final ArrayList<Contract> mappingDescriptors = new ArrayList<Contract>();
        try {
            Files.walkFileTree(Paths.get(descriptorsDirectory.toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    File file = path.toFile();
                    if (StubRepository.isContractDescriptor(file)) {
                        mappingDescriptors.add(ContractVerifierDslConverter.convert((File)file));
                    }
                    return super.visitFile(path, attrs);
                }
            });
        }
        catch (IOException e) {
            log.warn("Exception occurred while trying to parse file", (Throwable)e);
        }
        return mappingDescriptors;
    }

    private static boolean isMappingDescriptor(File file) {
        return file.isFile() && file.getName().endsWith(".json");
    }

    private static boolean isContractDescriptor(File file) {
        return file.isFile() && file.getName().endsWith(".groovy");
    }
}

