/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud.eureka;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.spring.cloud.eureka.Eureka;
import org.springframework.cloud.contract.stubrunner.spring.cloud.eureka.Registration;

class Renewer
implements Runnable {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    final Eureka eureka;
    final Registration registration;
    final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    Renewer(int flushInterval, Eureka eureka, Registration registration) {
        this.eureka = eureka;
        this.registration = registration;
        this.scheduler.scheduleWithFixedDelay(this, 0L, flushInterval, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Renewing registration [" + this.registration + "]"));
        }
        this.eureka.renew(this.registration);
    }
}

