/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.discovery.EurekaClientConfig;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.contract.stubrunner.StubRunning;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerConfiguration;
import org.springframework.cloud.contract.stubrunner.spring.cloud.ConditionalOnStubbedDiscoveryDisabled;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubMapperProperties;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubsRegistrar;
import org.springframework.cloud.contract.stubrunner.spring.cloud.eureka.ConditionalOnEurekaEnabled;
import org.springframework.cloud.contract.stubrunner.spring.cloud.eureka.Eureka;
import org.springframework.cloud.contract.stubrunner.spring.cloud.eureka.EurekaStubsRegistrar;
import org.springframework.cloud.netflix.eureka.CloudEurekaClient;
import org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={StubRunnerConfiguration.class, EurekaClientAutoConfiguration.class})
@ConditionalOnClass(value={CloudEurekaClient.class})
@ConditionalOnStubbedDiscoveryDisabled
@ConditionalOnEurekaEnabled
@ConditionalOnProperty(value={"stubrunner.cloud.eureka.enabled"}, matchIfMissing=true)
public class StubRunnerSpringCloudEurekaAutoConfiguration {
    @Bean(initMethod="registerStubs")
    public StubsRegistrar stubsRegistrar(StubRunning stubRunning, Eureka eureka, StubMapperProperties stubMapperProperties, InetUtils inetUtils, EurekaInstanceConfigBean eurekaInstanceConfigBean) {
        return new EurekaStubsRegistrar(stubRunning, eureka, stubMapperProperties, inetUtils, eurekaInstanceConfigBean);
    }

    @Bean(name={"eurekaRegistrar"})
    public Eureka eureka(InetUtils inetUtils, ApplicationInfoManager manager, EurekaClientConfig config, ApplicationContext applicationContext, EurekaClientConfigBean eurekaClientConfigBean) {
        return new Eureka(inetUtils, eurekaClientConfigBean, new CloudEurekaClient(manager, config, applicationContext));
    }
}

