/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.AetherStubDownloader;
import org.springframework.cloud.contract.stubrunner.ClasspathStubProvider;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class StubDownloaderBuilderProvider {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final List<StubDownloaderBuilder> builders = new ArrayList<StubDownloaderBuilder>();

    public StubDownloaderBuilderProvider() {
        this.builders.addAll(SpringFactoriesLoader.loadFactories(StubDownloaderBuilder.class, null));
    }

    public StubDownloaderBuilder get() {
        return this.builders.isEmpty() ? null : this.builders.get(0);
    }

    public StubDownloader getOrDefaultDownloader(StubRunnerOptions stubRunnerOptions) {
        if (this.hasBuilder()) {
            log.info((Object)("A custom Stub Downloader was passed - will pick [" + this.get() + "]"));
            return this.get().build(stubRunnerOptions);
        }
        if (stubRunnerOptions.stubsMode == StubRunnerProperties.StubsMode.CLASSPATH) {
            log.info((Object)"Classpath scanning will be used due to passed properties");
            return new ClasspathStubProvider().build(stubRunnerOptions);
        }
        log.info((Object)"Will download stubs using Aether");
        return new AetherStubDownloader(stubRunnerOptions);
    }

    public boolean hasBuilder() {
        return this.get() != null;
    }
}

