/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.util.Collection;
import java.util.Map;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.stubrunner.util.StringUtils;

public class StubRunnerOptions {
    final Integer minPortValue;
    final Integer maxPortValue;
    final String stubRepositoryRoot;
    final String stubsClassifier;
    final Collection<StubConfiguration> dependencies;
    final Map<StubConfiguration, Integer> stubIdsToPortMapping;
    final String username;
    final String password;
    private final StubRunnerProxyOptions stubRunnerProxyOptions;
    private boolean stubsPerConsumer = false;
    private String consumerName;
    private String mappingsOutputFolder;
    final StubRunnerProperties.StubsMode stubsMode;
    private boolean snapshotCheckSkip;

    StubRunnerOptions(Integer minPortValue, Integer maxPortValue, String stubRepositoryRoot, StubRunnerProperties.StubsMode stubsMode, String stubsClassifier, Collection<StubConfiguration> dependencies, Map<StubConfiguration, Integer> stubIdsToPortMapping, String username, String password, StubRunnerProxyOptions stubRunnerProxyOptions, boolean stubsPerConsumer, String consumerName, String mappingsOutputFolder, boolean snapshotCheckSkip) {
        this.minPortValue = minPortValue;
        this.maxPortValue = maxPortValue;
        this.stubRepositoryRoot = stubRepositoryRoot;
        this.stubsMode = stubsMode != null ? stubsMode : StubRunnerProperties.StubsMode.CLASSPATH;
        this.stubsClassifier = stubsClassifier;
        this.dependencies = dependencies;
        this.stubIdsToPortMapping = stubIdsToPortMapping;
        this.username = username;
        this.password = password;
        this.stubRunnerProxyOptions = stubRunnerProxyOptions;
        this.stubsPerConsumer = stubsPerConsumer;
        this.consumerName = consumerName;
        this.mappingsOutputFolder = mappingsOutputFolder;
        this.snapshotCheckSkip = snapshotCheckSkip;
    }

    public Integer port(StubConfiguration stubConfiguration) {
        if (this.stubIdsToPortMapping != null) {
            return this.stubIdsToPortMapping.get(stubConfiguration);
        }
        return null;
    }

    public static StubRunnerOptions fromSystemProps() {
        StubRunnerOptionsBuilder builder = new StubRunnerOptionsBuilder().withMinPort(Integer.valueOf(System.getProperty("stubrunner.port.range.min", "10000"))).withMaxPort(Integer.valueOf(System.getProperty("stubrunner.port.range.max", "15000"))).withStubRepositoryRoot(System.getProperty("stubrunner.repository.root", "")).withStubsMode(System.getProperty("stubrunner.stubs-mode", "CLASSPATH")).withStubsClassifier(System.getProperty("stubrunner.classifier", "stubs")).withStubs(System.getProperty("stubrunner.ids", "")).withUsername(System.getProperty("stubrunner.username")).withPassword(System.getProperty("stubrunner.password")).withStubPerConsumer(Boolean.parseBoolean(System.getProperty("stubrunner.stubs-per-consumer", "false"))).withConsumerName(System.getProperty("stubrunner.consumer-name")).withMappingsOutputFolder(System.getProperty("stubrunner.mappings-output-folder")).withSnapshotCheckSkip(Boolean.parseBoolean(System.getProperty("stubrunner.snapshot-check-skip", "false")));
        String proxyHost = System.getProperty("stubrunner.proxy.host");
        if (proxyHost != null) {
            builder.withProxy(proxyHost, Integer.parseInt(System.getProperty("stubrunner.proxy.port")));
        }
        return builder.build();
    }

    public Integer getMinPortValue() {
        return this.minPortValue;
    }

    public Integer getMaxPortValue() {
        return this.maxPortValue;
    }

    public Collection<StubConfiguration> getDependencies() {
        return this.dependencies;
    }

    public Map<StubConfiguration, Integer> getStubIdsToPortMapping() {
        return this.stubIdsToPortMapping;
    }

    public String getStubRepositoryRoot() {
        return this.stubRepositoryRoot;
    }

    public StubRunnerProperties.StubsMode getStubsMode() {
        return this.stubsMode;
    }

    public String getStubsClassifier() {
        return this.stubsClassifier;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public StubRunnerProxyOptions getStubRunnerProxyOptions() {
        return this.stubRunnerProxyOptions;
    }

    public StubRunnerProxyOptions getProxyOptions() {
        return this.stubRunnerProxyOptions;
    }

    public boolean isStubsPerConsumer() {
        return this.stubsPerConsumer;
    }

    public void setStubsPerConsumer(boolean stubsPerConsumer) {
        this.stubsPerConsumer = stubsPerConsumer;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public boolean hasMappingsOutputFolder() {
        return StringUtils.hasText(this.mappingsOutputFolder);
    }

    public String getMappingsOutputFolder() {
        return this.mappingsOutputFolder;
    }

    public void setMappingsOutputFolder(String mappingsOutputFolder) {
        this.mappingsOutputFolder = mappingsOutputFolder;
    }

    public boolean isSnapshotCheckSkip() {
        return this.snapshotCheckSkip;
    }

    public void setSnapshotCheckSkip(boolean snapshotCheckSkip) {
        this.snapshotCheckSkip = snapshotCheckSkip;
    }

    public String toString() {
        return "StubRunnerOptions{minPortValue=" + this.minPortValue + ", maxPortValue=" + this.maxPortValue + ", stubRepositoryRoot='" + this.stubRepositoryRoot + '\'' + ", stubsMode='" + (Object)((Object)this.stubsMode) + "', stubsClassifier='" + this.stubsClassifier + '\'' + ", dependencies=" + this.dependencies + ", stubIdsToPortMapping=" + this.stubIdsToPortMapping + ", username='" + this.obfuscate(this.username) + '\'' + ", password='" + this.obfuscate(this.password) + '\'' + ", stubRunnerProxyOptions='" + this.stubRunnerProxyOptions + "', stubsPerConsumer='" + this.stubsPerConsumer + '\'' + ", stubsPerConsumer='" + this.stubsPerConsumer + '\'' + '}';
    }

    private String obfuscate(String string) {
        return StringUtils.hasText(string) ? "****" : "";
    }

    public static class StubRunnerProxyOptions {
        private final String proxyHost;
        private final int proxyPort;

        public StubRunnerProxyOptions(String proxyHost, int proxyPort) {
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public String toString() {
            return "StubRunnerProxyOptions{proxyHost='" + this.proxyHost + '\'' + ", proxyPort=" + this.proxyPort + '}';
        }
    }
}

