/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.contract.stubrunner.ResourceResolver;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.stubrunner.util.StubsParser;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class StubRunnerOptionsBuilder {
    private static final String DELIMITER = ":";
    private LinkedList<String> stubs = new LinkedList();
    private Collection<StubConfiguration> stubConfigurations = new ArrayList<StubConfiguration>();
    private Map<StubConfiguration, Integer> stubIdsToPortMapping = new LinkedHashMap<StubConfiguration, Integer>();
    private Integer minPortValue = 10000;
    private Integer maxPortValue = 15000;
    private Resource stubRepositoryRoot;
    private String stubsClassifier = "stubs";
    private String username;
    private String password;
    private StubRunnerOptions.StubRunnerProxyOptions stubRunnerProxyOptions;
    private boolean stubsPerConsumer = false;
    private String consumerName;
    private String mappingsOutputFolder;
    private StubRunnerProperties.StubsMode stubsMode;
    private boolean deleteStubsAfterTest = true;
    private Map<String, String> properties = new HashMap<String, String>();

    public StubRunnerOptionsBuilder() {
    }

    public StubRunnerOptionsBuilder(StubRunnerOptions options) {
        this.withOptions(options);
    }

    public StubRunnerOptionsBuilder withStubs(String ... stubs) {
        this.addStub(StubRunnerOptionsBuilder.stubsToList(stubs));
        return this;
    }

    public StubRunnerOptionsBuilder withStubs(List<String> stubs) {
        for (String stub : stubs) {
            this.withStubs(stub);
        }
        return this;
    }

    public StubRunnerOptionsBuilder withMinMaxPort(Integer minPortValue, Integer maxPortValue) {
        this.minPortValue = minPortValue;
        this.maxPortValue = maxPortValue;
        return this;
    }

    public StubRunnerOptionsBuilder withMinPort(int minPortValue) {
        this.minPortValue = minPortValue;
        return this;
    }

    public StubRunnerOptionsBuilder withMaxPort(int maxPortValue) {
        this.maxPortValue = maxPortValue;
        return this;
    }

    public StubRunnerOptionsBuilder withStubRepositoryRoot(Resource stubRepositoryRoot) {
        this.stubRepositoryRoot = stubRepositoryRoot;
        return this;
    }

    public StubRunnerOptionsBuilder withStubRepositoryRoot(String stubRepositoryRoot) {
        if (StringUtils.hasText((String)stubRepositoryRoot)) {
            this.stubRepositoryRoot = ResourceResolver.resource(stubRepositoryRoot);
        }
        return this;
    }

    public StubRunnerOptionsBuilder withStubsMode(StubRunnerProperties.StubsMode stubsMode) {
        this.stubsMode = stubsMode;
        return this;
    }

    public StubRunnerOptionsBuilder withStubsMode(String stubsMode) {
        this.stubsMode = StubRunnerProperties.StubsMode.valueOf(stubsMode);
        return this;
    }

    public StubRunnerOptionsBuilder withStubsClassifier(String stubsClassifier) {
        this.stubsClassifier = stubsClassifier;
        return this;
    }

    public StubRunnerOptionsBuilder withPort(Integer port) {
        String lastStub = this.stubs.peekLast();
        this.addPort(lastStub + DELIMITER + port);
        return this;
    }

    public StubRunnerOptionsBuilder withOptions(StubRunnerOptions options) {
        this.minPortValue = options.minPortValue;
        this.maxPortValue = options.maxPortValue;
        this.stubRepositoryRoot = options.stubRepositoryRoot;
        this.stubsMode = options.stubsMode;
        this.stubsClassifier = options.stubsClassifier;
        this.username = options.username;
        this.password = options.password;
        this.stubRunnerProxyOptions = options.getStubRunnerProxyOptions();
        this.stubsPerConsumer = options.isStubsPerConsumer();
        this.consumerName = options.getConsumerName();
        this.mappingsOutputFolder = options.getMappingsOutputFolder();
        this.stubConfigurations = options.dependencies != null ? options.dependencies : new ArrayList<StubConfiguration>();
        this.stubIdsToPortMapping = options.stubIdsToPortMapping != null ? options.stubIdsToPortMapping : new LinkedHashMap<StubConfiguration, Integer>();
        this.deleteStubsAfterTest = options.isDeleteStubsAfterTest();
        this.properties = options.getProperties();
        return this;
    }

    public StubRunnerOptionsBuilder withMappingsOutputFolder(String mappingsOutputFolder) {
        this.mappingsOutputFolder = mappingsOutputFolder;
        return this;
    }

    public StubRunnerOptionsBuilder withDeleteStubsAfterTest(boolean deleteStubsAfterTest) {
        this.deleteStubsAfterTest = deleteStubsAfterTest;
        return this;
    }

    public StubRunnerOptionsBuilder withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public StubRunnerOptions build() {
        return new StubRunnerOptions(this.minPortValue, this.maxPortValue, this.stubRepositoryRoot, this.stubsMode, this.stubsClassifier, this.buildDependencies(), this.stubIdsToPortMapping, this.username, this.password, this.stubRunnerProxyOptions, this.stubsPerConsumer, this.consumerName, this.mappingsOutputFolder, this.deleteStubsAfterTest, this.properties);
    }

    private Collection<StubConfiguration> buildDependencies() {
        List<StubConfiguration> stubConfigurations = StubsParser.fromString(this.stubs, this.stubsClassifier);
        this.stubConfigurations.addAll(stubConfigurations);
        return this.stubConfigurations;
    }

    private static List<String> stubsToList(String[] stubIdsToPortMapping) {
        ArrayList<String> list = new ArrayList<String>();
        if (stubIdsToPortMapping.length == 1 && !StubRunnerOptionsBuilder.containsRange(stubIdsToPortMapping[0])) {
            list.addAll(StringUtils.commaDelimitedListToSet((String)stubIdsToPortMapping[0]));
            return list;
        }
        if (stubIdsToPortMapping.length == 1 && StubRunnerOptionsBuilder.containsRange(stubIdsToPortMapping[0])) {
            String[] split;
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String string : split = stubIdsToPortMapping[0].split(",")) {
                if (StubRunnerOptionsBuilder.containsClosingRange(string)) {
                    String last = (String)linkedList.pop();
                    linkedList.push(last + "," + string);
                    continue;
                }
                linkedList.push(string);
            }
            list.addAll(linkedList);
            return list;
        }
        Collections.addAll(list, stubIdsToPortMapping);
        return list;
    }

    private static boolean containsRange(String s) {
        return s.contains("[") || s.contains("(");
    }

    private static boolean containsClosingRange(String s) {
        return s.contains("]") || s.contains(")");
    }

    private void addStub(List<String> notations) {
        for (String notation : notations) {
            this.addStub(notation);
        }
    }

    private void addStub(String notation) {
        if (StubsParser.hasPort(notation)) {
            this.addPort(notation);
            this.stubs.add(StubsParser.ivyFromStringWithPort(notation));
        } else {
            this.stubs.add(notation);
        }
    }

    private void addPort(String notation) {
        this.putStubIdsToPortMapping(StubsParser.fromStringWithPort(notation));
    }

    private void putStubIdsToPortMapping(Map<StubConfiguration, Integer> stubIdsToPortMapping) {
        this.stubIdsToPortMapping.putAll(stubIdsToPortMapping);
    }

    public StubRunnerOptionsBuilder withUsername(String username) {
        this.username = username;
        return this;
    }

    public StubRunnerOptionsBuilder withPassword(String password) {
        this.password = password;
        return this;
    }

    public StubRunnerOptionsBuilder withProxy(String proxyHost, int proxyPort) {
        this.stubRunnerProxyOptions = new StubRunnerOptions.StubRunnerProxyOptions(proxyHost, proxyPort);
        return this;
    }

    public StubRunnerOptionsBuilder withStubPerConsumer(boolean stubPerConsumer) {
        this.stubsPerConsumer = stubPerConsumer;
        return this;
    }

    public StubRunnerOptionsBuilder withConsumerName(String consumerName) {
        this.consumerName = consumerName;
        return this;
    }
}

