/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.provider.wiremock;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.provider.wiremock.WireMockHttpServerStub;
import org.springframework.cloud.contract.stubrunner.spring.AutoConfigureStubRunner;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public final class StubRunnerWireMockTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log log = LogFactory.getLog(StubRunnerWireMockTestExecutionListener.class);

    public void afterTestClass(TestContext testContext) {
        if (((AutoConfigureStubRunner[])testContext.getTestClass().getAnnotationsByType(AutoConfigureStubRunner.class)).length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No @AutoConfigureStubRunner annotation found on [" + testContext.getTestClass() + "]. Skipping"));
            }
            return;
        }
        if (WireMockHttpServerStub.SERVERS.values().stream().anyMatch(p -> !p.random)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"You've used fixed ports for WireMock setup - will mark context as dirty. Please use random ports, as much as possible. Your tests will be faster and more reliable and thiswarning will go away");
            }
            testContext.markApplicationContextDirty(DirtiesContext.HierarchyMode.EXHAUSTIVE);
        }
        WireMockHttpServerStub.SERVERS.clear();
    }
}

