/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.jms;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.MessageListener;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.messaging.jms.StubRunnerJmsRouter;
import org.springframework.cloud.contract.verifier.util.MapConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.MessageListenerContainer;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={JmsTemplate.class})
@ConditionalOnProperty(name={"stubrunner.jms.enabled"}, havingValue="true", matchIfMissing=true)
public class StubRunnerJmsConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"stubFlowRegistrar"})
    public FlowRegistrar stubFlowRegistrar(ConfigurableListableBeanFactory beanFactory, BatchStubRunner batchStubRunner) {
        Map<StubConfiguration, Collection<Contract>> contracts = batchStubRunner.getContracts();
        for (Map.Entry<StubConfiguration, Collection<Contract>> entry : contracts.entrySet()) {
            StubConfiguration key = entry.getKey();
            Collection<Contract> value = entry.getValue();
            String name = key.getGroupId() + "_" + key.getArtifactId();
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            for (Contract dsl : value) {
                if (dsl == null || dsl.getInput() == null || dsl.getInput().getMessageFrom() == null || !StringUtils.hasText((String)((String)dsl.getInput().getMessageFrom().getClientValue()))) continue;
                String from = (String)dsl.getInput().getMessageFrom().getClientValue();
                map.add((Object)from, (Object)dsl);
            }
            for (Map.Entry entries : map.entrySet()) {
                List matchingContracts = (List)entries.getValue();
                String flowName = name + "_" + (String)entries.getKey() + "_" + Math.abs(matchingContracts.hashCode());
                StubRunnerJmsRouter router = new StubRunnerJmsRouter(matchingContracts, (BeanFactory)beanFactory);
                StubRunnerJmsRouter listener = (StubRunnerJmsRouter)beanFactory.initializeBean((Object)router, flowName);
                beanFactory.registerSingleton(flowName, (Object)listener);
                this.registerContainers(beanFactory, matchingContracts, flowName, listener);
            }
        }
        return new FlowRegistrar();
    }

    private void registerContainers(ConfigurableListableBeanFactory beanFactory, List<Contract> matchingContracts, String flowName, StubRunnerJmsRouter listener) {
        ConnectionFactory connectionFactory = (ConnectionFactory)beanFactory.getBean(ConnectionFactory.class);
        for (Contract matchingContract : matchingContracts) {
            if (matchingContract.getInput() == null) continue;
            String destination = MapConverter.getStubSideValuesForNonBody((Object)matchingContract.getInput().getMessageFrom()).toString();
            MessageListenerContainer container = this.listenerContainer(destination, connectionFactory, listener);
            String containerName = flowName + ".container";
            Object initializedContainer = beanFactory.initializeBean((Object)container, containerName);
            beanFactory.registerSingleton(containerName, initializedContainer);
        }
    }

    private MessageListenerContainer listenerContainer(String queueName, ConnectionFactory connectionFactory, MessageListener listener) {
        DefaultMessageListenerContainer container = new DefaultMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        container.setDestinationName(queueName);
        container.setMessageListener((Object)listener);
        return container;
    }

    static class FlowRegistrar {
        FlowRegistrar() {
        }
    }
}

