/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.jms;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

final class StubRunnerJmsAccessor {
    private StubRunnerJmsAccessor() {
        throw new IllegalStateException("Can't instantiate an utility class");
    }

    static Object getBody(Message message) {
        try {
            return StubRunnerJmsAccessor.getPayload(message);
        }
        catch (JMSException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static Map<String, Object> getHeaders(Message message) {
        try {
            return StubRunnerJmsAccessor.headers(message);
        }
        catch (JMSException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Map<String, Object> headers(Message message) throws JMSException {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        if (message == null) {
            return headers;
        }
        Enumeration enumeration = message.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            Object element = enumeration.nextElement();
            String asString = element.toString();
            Object property = message.getObjectProperty(asString);
            headers.put(asString, property);
        }
        return headers;
    }

    private static Object getPayload(Message message) throws JMSException {
        if (message == null) {
            return null;
        }
        if (message instanceof TextMessage) {
            return ((TextMessage)message).getText();
        }
        if (message instanceof StreamMessage) {
            return ((StreamMessage)message).readObject();
        }
        if (message instanceof ObjectMessage) {
            return ((ObjectMessage)message).getObject();
        }
        return message.getBody(Object.class);
    }
}

