/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import io.micrometer.common.lang.Nullable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractConverter;
import org.springframework.cloud.contract.stubrunner.HttpServerStub;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.stubrunner.provider.wiremock.WireMockHttpServerStub;
import org.springframework.cloud.contract.verifier.util.ContractScanner;
import org.springframework.core.io.support.SpringFactoriesLoader;

class StubRepository {
    private static final Log log = LogFactory.getLog(StubRepository.class);
    final List<File> stubs;
    final Collection<Contract> contracts;
    private final File path;
    private final List<ContractConverter> contractConverters;
    private final List<HttpServerStub> httpServerStubs;
    private final StubRunnerOptions options;

    StubRepository(File repository, List<HttpServerStub> httpServerStubs, StubRunnerOptions options, @Nullable StubConfiguration stubConfiguration) {
        if (!repository.isDirectory()) {
            throw new IllegalArgumentException("Missing descriptor repository under path [" + repository + "]");
        }
        this.contractConverters = SpringFactoriesLoader.loadFactories(ContractConverter.class, null);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Found the following contract converters " + this.contractConverters));
        }
        this.httpServerStubs = httpServerStubs;
        this.path = repository;
        this.options = options;
        this.stubs = this.stubs();
        this.contracts = this.contracts();
        if (options.isFailOnNoStubs() && this.stubs.isEmpty() && this.contracts.isEmpty()) {
            throw new IllegalStateException("No stubs or contracts were found for [" + (stubConfiguration != null ? stubConfiguration.toColonSeparatedDependencyNotation() : null) + "] and the switch to fail on no stubs was set.");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Found the following contracts " + this.contracts));
        }
    }

    StubRepository(File repository) {
        this(repository, new ArrayList<HttpServerStub>(), new StubRunnerOptionsBuilder().build(), null);
    }

    public File getPath() {
        return this.path;
    }

    public List<File> getStubs() {
        return this.stubs;
    }

    public Collection<Contract> getContracts() {
        return this.contracts;
    }

    private Collection<Contract> contracts() {
        return new ArrayList<Contract>(this.contractDescriptors());
    }

    private List<File> stubs() {
        return new ArrayList<File>(this.collectedStubs());
    }

    private List<File> collectedStubs() {
        return this.path.exists() ? this.collectMappings(this.path) : Collections.emptyList();
    }

    private List<File> collectMappings(File descriptorsDirectory) {
        final ArrayList<File> mappingDescriptors = new ArrayList<File>();
        try {
            Files.walkFileTree(Paths.get(descriptorsDirectory.toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    File file = path.toFile();
                    if (StubRepository.this.httpServerStubAccepts(file) && StubRepository.this.isStubPerConsumerPathMatching(file)) {
                        mappingDescriptors.add(file);
                    }
                    return super.visitFile(path, attrs);
                }
            });
        }
        catch (IOException e) {
            log.warn((Object)"Exception occurred while trying to parse file", (Throwable)e);
        }
        return mappingDescriptors;
    }

    private ContractConverter contractConverter(File file) {
        for (ContractConverter converter : this.contractConverters) {
            if (!converter.isAccepted(file)) continue;
            return converter;
        }
        return null;
    }

    private boolean httpServerStubAccepts(File file) {
        for (HttpServerStub httpServerStub : this.httpServerStubs) {
            if (!httpServerStub.isAccepted(file)) continue;
            return true;
        }
        return new WireMockHttpServerStub().isAccepted(file);
    }

    private Collection<Contract> contractDescriptors() {
        return this.path.exists() ? ContractScanner.collectContractDescriptors((File)this.path, this::isStubPerConsumerPathMatching) : Collections.emptySet();
    }

    private boolean isStubPerConsumerPathMatching(File file) {
        if (!this.options.isStubsPerConsumer()) {
            return true;
        }
        String consumerName = this.options.getConsumerName();
        String searchedConsumerName = File.separator + consumerName + File.separator;
        String absolutePath = file.getAbsolutePath();
        boolean stubPerConsumerMatching = absolutePath.contains(searchedConsumerName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Absolute path [" + absolutePath + "] contains [" + searchedConsumerName + "] in its path [" + stubPerConsumerMatching + "]"));
        }
        return stubPerConsumerMatching;
    }
}

