/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.MethodBuilder;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.config.TestFramework;
import org.springframework.cloud.contract.verifier.util.NamesUtil;

class ClassBuilder
implements GroovyObject {
    private static final String SEPARATOR = "_REPLACEME_";
    private final String className;
    private final String packageName;
    private final String baseClass;
    private final List<String> imports;
    private final List<String> staticImports;
    private final List<String> rules;
    private final List<String> fields;
    private final List<MethodBuilder> methods;
    private final List<String> classLevelAnnotations;
    private final TestFramework lang;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    private ClassBuilder(String className, String packageName, String baseClass, TestFramework lang) {
        String string;
        String string2;
        String string3;
        TestFramework testFramework;
        MetaClass metaClass;
        List list;
        List list2;
        List list3;
        List list4;
        List list5;
        List list6;
        this.imports = list6 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.staticImports = list5 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.rules = list4 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.fields = list3 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.methods = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.classLevelAnnotations = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.lang = testFramework = lang;
        if (DefaultTypeTransformation.booleanUnbox((Object)baseClass)) {
            DefaultGroovyMethods.leftShift(this.imports, (Object)baseClass);
        }
        this.baseClass = string3 = NamesUtil.afterLastDot(baseClass);
        this.packageName = string2 = packageName;
        this.className = string = className;
    }

    public static ClassBuilder createClass(String className, String classPackage, ContractVerifierConfigProperties properties, String includedDirectoryRelativePath) {
        String string;
        String string2;
        String baseClassForTests = null;
        baseClassForTests = ScriptBytecodeAdapter.compareEqual((Object)((Object)properties.getTargetFramework()), (Object)((Object)TestFramework.SPOCK)) && !DefaultTypeTransformation.booleanUnbox((Object)properties.getBaseClassForTests()) && !DefaultTypeTransformation.booleanUnbox((Object)properties.getPackageWithBaseClasses()) && !DefaultTypeTransformation.booleanUnbox(properties.getBaseClassMappings()) ? (string2 = "spock.lang.Specification") : (string = ClassBuilder.retrieveBaseClass(properties, includedDirectoryRelativePath));
        return new ClassBuilder(className, classPackage, baseClassForTests, properties.getTargetFramework());
    }

    protected static String retrieveBaseClass(ContractVerifierConfigProperties properties, String includedDirectoryRelativePath) {
        Reference contractPackage = new Reference((Object)includedDirectoryRelativePath.replace(File.separator, SEPARATOR));
        if (DefaultTypeTransformation.booleanUnbox(properties.getBaseClassMappings())) {
            public class _retrieveBaseClass_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference contractPackage;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _retrieveBaseClass_closure1(Object _outerInstance, Object _thisObject, Reference contractPackage) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.contractPackage = reference = contractPackage;
                }

                public Object doCall(String pattern, String fqn) {
                    return ((String)this.contractPackage.get()).matches(pattern);
                }

                public Object call(String pattern, String fqn) {
                    return this.doCall(pattern, fqn);
                }

                public String getContractPackage() {
                    return ShortTypeHandling.castToString((Object)this.contractPackage.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _retrieveBaseClass_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Map.Entry mapping = DefaultGroovyMethods.find(properties.getBaseClassMappings(), (Closure)new _retrieveBaseClass_closure1(ClassBuilder.class, ClassBuilder.class, contractPackage));
            if (DefaultTypeTransformation.booleanUnbox((Object)mapping)) {
                return ShortTypeHandling.castToString(mapping.getValue());
            }
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)properties.getPackageWithBaseClasses())) {
            return properties.getBaseClassForTests();
        }
        String generatedClassName = ClassBuilder.generateDefaultBaseClassName((String)contractPackage.get(), properties);
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{generatedClassName}, new String[]{"", "Base"}));
    }

    private static String generateDefaultBaseClassName(String classPackage, ContractVerifierConfigProperties properties) {
        Object[] splitPackage = NamesUtil.convertIllegalPackageChars(classPackage).split(SEPARATOR);
        if (DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)splitPackage, Object[].class))) > 1) {
            String last = NamesUtil.capitalize(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])splitPackage, (int)-1)));
            String butLast = NamesUtil.capitalize(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])splitPackage, (int)-2)));
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{properties.getPackageWithBaseClasses(), butLast, last}, new String[]{"", ".", "", ""}));
        }
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{properties.getPackageWithBaseClasses(), NamesUtil.capitalize(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])splitPackage, (int)0)))}, new String[]{"", ".", ""}));
    }

    public ClassBuilder addImport(String importToAdd) {
        DefaultGroovyMethods.leftShift(this.imports, (Object)importToAdd);
        return this;
    }

    public ClassBuilder addImport(List<String> importsToAdd) {
        this.imports.addAll(importsToAdd);
        return this;
    }

    public ClassBuilder addStaticImport(String importToAdd) {
        DefaultGroovyMethods.leftShift(this.staticImports, (Object)importToAdd);
        return this;
    }

    public ClassBuilder addMethod(MethodBuilder methodBuilder) {
        DefaultGroovyMethods.leftShift(this.methods, (Object)methodBuilder);
        return this;
    }

    public ClassBuilder addField(String fieldToAdd) {
        DefaultGroovyMethods.leftShift(this.fields, (Object)this.appendColonIfJUniTest(fieldToAdd));
        return this;
    }

    private String appendColonIfJUniTest(String field) {
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.lang), (Object)((Object)TestFramework.JUNIT)) && !field.endsWith(";")) {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{field}, new String[]{"", ";"}));
        }
        return field;
    }

    public ClassBuilder addField(List<String> fieldsToAdd) {
        public class _addField_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addField_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((ClassBuilder)this.getThisObject()).appendColonIfJUniTest(ShortTypeHandling.castToString((Object)it));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addField_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.fields.addAll(DefaultGroovyMethods.collect(fieldsToAdd, (Closure)new _addField_closure2(this, this)));
        return this;
    }

    public ClassBuilder addRule(String ruleClass) {
        DefaultGroovyMethods.leftShift(this.imports, (Object)ruleClass);
        DefaultGroovyMethods.leftShift(this.rules, (Object)NamesUtil.afterLastDot(ruleClass));
        return this;
    }

    public String build() {
        Reference clazz = new Reference((Object)new BlockBuilder("\t").addLine(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.packageName, this.lang.getLineSuffix()}, new String[]{"package ", "", ""}))).addEmptyLine());
        public class _build_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference clazz;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _build_closure3(Object _outerInstance, Object _thisObject, Reference clazz) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.clazz = reference = clazz;
            }

            public Object doCall(Object it) {
                return ((BlockBuilder)this.clazz.get()).addLine(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{it, ((ClassBuilder)this.getThisObject()).lang.getLineSuffix()}, new String[]{"import ", "", ""})));
            }

            public BlockBuilder getClazz() {
                return (BlockBuilder)ScriptBytecodeAdapter.castToType((Object)this.clazz.get(), BlockBuilder.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _build_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)DefaultGroovyMethods.sort(this.imports), (Closure)new _build_closure3(this, this, clazz));
        if (!this.imports.isEmpty()) {
            ((BlockBuilder)clazz.get()).addEmptyLine();
        }
        public class _build_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference clazz;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _build_closure4(Object _outerInstance, Object _thisObject, Reference clazz) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.clazz = reference = clazz;
            }

            public Object doCall(Object it) {
                return ((BlockBuilder)this.clazz.get()).addLine(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{it, ((ClassBuilder)this.getThisObject()).lang.getLineSuffix()}, new String[]{"import static ", "", ""})));
            }

            public BlockBuilder getClazz() {
                return (BlockBuilder)ScriptBytecodeAdapter.castToType((Object)this.clazz.get(), BlockBuilder.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _build_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)DefaultGroovyMethods.sort(this.staticImports), (Closure)new _build_closure4(this, this, clazz));
        if (!this.staticImports.isEmpty()) {
            ((BlockBuilder)clazz.get()).addEmptyLine();
        }
        public class _build_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference clazz;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _build_closure5(Object _outerInstance, Object _thisObject, Reference clazz) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.clazz = reference = clazz;
            }

            public Object doCall(Object it) {
                return ((BlockBuilder)this.clazz.get()).addLine(ShortTypeHandling.castToString((Object)it));
            }

            public BlockBuilder getClazz() {
                return (BlockBuilder)ScriptBytecodeAdapter.castToType((Object)this.clazz.get(), BlockBuilder.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _build_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)DefaultGroovyMethods.sort(this.classLevelAnnotations), (Closure)new _build_closure5(this, this, clazz));
        GStringImpl classLine = new GStringImpl(new Object[]{this.lang.getClassModifier(), this.className}, new String[]{"", "class ", ""});
        if (DefaultTypeTransformation.booleanUnbox((Object)this.baseClass)) {
            GString gString = classLine.plus((GString)new GStringImpl(new Object[]{this.baseClass}, new String[]{" extends ", ""}));
            classLine = gString;
        }
        ((BlockBuilder)clazz.get()).addLine(ShortTypeHandling.castToString((Object)classLine.plus(" {")));
        ((BlockBuilder)clazz.get()).addEmptyLine();
        ((BlockBuilder)clazz.get()).startBlock();
        public class _build_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference clazz;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _build_closure6(Object _outerInstance, Object _thisObject, Reference clazz) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.clazz = reference = clazz;
            }

            public Object doCall(Object it) {
                ((BlockBuilder)this.clazz.get()).addLine("@Rule");
                return ((BlockBuilder)this.clazz.get()).addLine(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{it, NamesUtil.camelCase(ShortTypeHandling.castToString((Object)it)), it, ((ClassBuilder)this.getThisObject()).lang.getLineSuffix()}, new String[]{"public ", " ", " = new ", "()", ""})));
            }

            public BlockBuilder getClazz() {
                return (BlockBuilder)ScriptBytecodeAdapter.castToType((Object)this.clazz.get(), BlockBuilder.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _build_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)DefaultGroovyMethods.sort(this.rules), (Closure)new _build_closure6(this, this, clazz));
        ((BlockBuilder)clazz.get()).endBlock();
        if (!this.rules.isEmpty()) {
            ((BlockBuilder)clazz.get()).addEmptyLine();
        }
        ((BlockBuilder)clazz.get()).startBlock();
        public class _build_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference clazz;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _build_closure7(Object _outerInstance, Object _thisObject, Reference clazz) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.clazz = reference = clazz;
            }

            public Object doCall(Object it) {
                return ((BlockBuilder)this.clazz.get()).addLine(ShortTypeHandling.castToString((Object)it));
            }

            public BlockBuilder getClazz() {
                return (BlockBuilder)ScriptBytecodeAdapter.castToType((Object)this.clazz.get(), BlockBuilder.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _build_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)DefaultGroovyMethods.sort(this.fields), (Closure)new _build_closure7(this, this, clazz));
        if (!this.fields.isEmpty()) {
            ((BlockBuilder)clazz.get()).addEmptyLine();
        }
        ((BlockBuilder)clazz.get()).endBlock();
        public class _build_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference clazz;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _build_closure8(Object _outerInstance, Object _thisObject, Reference clazz) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.clazz = reference = clazz;
            }

            public Object doCall(Object it) {
                return InvokerHelper.invokeMethodSafe((Object)this.clazz.get(), (String)"addBlock", (Object)new Object[]{it});
            }

            public BlockBuilder getClazz() {
                return (BlockBuilder)ScriptBytecodeAdapter.castToType((Object)this.clazz.get(), BlockBuilder.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _build_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.methods, (Closure)new _build_closure8(this, this, clazz));
        ((BlockBuilder)clazz.get()).addLine("}");
        return ((BlockBuilder)clazz.get()).toString();
    }

    public void addClassLevelAnnotation(String annotation) {
        DefaultGroovyMethods.leftShift(this.classLevelAnnotations, (Object)annotation);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ClassBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

