/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.integration;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.integration.ContractVerifierIntegrationMessageBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;

public class SpringIntegrationStubMessages
implements MessageVerifier<Message<?>> {
    private static final Logger log = LoggerFactory.getLogger(SpringIntegrationStubMessages.class);
    private final ApplicationContext context;
    private final ContractVerifierIntegrationMessageBuilder builder = new ContractVerifierIntegrationMessageBuilder();

    @Autowired
    public SpringIntegrationStubMessages(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public <T> void send(T payload, Map<String, Object> headers, String destination) {
        this.send(this.builder.create(payload, headers), destination);
    }

    @Override
    public void send(Message<?> message, String destination) {
        try {
            MessageChannel messageChannel = (MessageChannel)this.context.getBean(destination, MessageChannel.class);
            messageChannel.send(message);
        }
        catch (Exception e) {
            log.error("Exception occurred while trying to send a message [" + message + "] to a channel with name [" + destination + "]", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Message<?> receive(String destination, long timeout, TimeUnit timeUnit) {
        try {
            PollableChannel messageChannel = (PollableChannel)this.context.getBean(destination, PollableChannel.class);
            return messageChannel.receive(timeUnit.toMillis(timeout));
        }
        catch (Exception e) {
            log.error("Exception occurred while trying to read a message from  a channel with name [" + destination + "]", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Message<?> receive(String destination) {
        return this.receive(destination, 5L, TimeUnit.SECONDS);
    }
}

