/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.MethodAnnotations;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.config.TestFramework;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class JUnit4IgnoreMethodAnnotation
implements MethodAnnotations {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private static final String[] ANNOTATIONS = new String[]{"@Ignore"};

    JUnit4IgnoreMethodAnnotation(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
    }

    @Override
    public MethodVisitor<MethodAnnotations> apply(SingleContractMetadata singleContractMetadata) {
        Arrays.stream(ANNOTATIONS).forEach(this.blockBuilder::addIndented);
        return this;
    }

    @Override
    public boolean accept(SingleContractMetadata singleContractMetadata) {
        return this.generatedClassMetaData.configProperties.getTestFramework() == TestFramework.JUNIT && this.generatedClassMetaData.isAnyIgnored();
    }
}

