/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.kafka;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.messaging.kafka.Record;
import org.springframework.kafka.test.utils.KafkaTestUtils;
import org.springframework.messaging.Message;

class Receiver {
    private final Map<String, Consumer> consumers;
    private static final Log log = LogFactory.getLog(Receiver.class);

    Receiver(Map<String, Consumer> consumers) {
        this.consumers = consumers;
    }

    Message receive(String topic, long timeout, TimeUnit timeUnit, YamlContract contract) {
        Consumer consumer = this.consumers.get(topic);
        if (consumer == null) {
            throw new IllegalStateException("No consumer set up for topic [" + topic + "]");
        }
        ConsumerRecord record = KafkaTestUtils.getSingleRecord((Consumer)consumer, (String)topic, (long)timeUnit.toMillis(timeout));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got a single record for destination [" + topic + "]"));
        }
        return new Record(record).toMessage();
    }
}

