/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.spec.internal.Input;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.BodyReader;
import org.springframework.cloud.contract.verifier.builder.CommunicationType;
import org.springframework.cloud.contract.verifier.builder.Given;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.ContentType;

class MessagingBodyGiven
implements Given,
MethodVisitor<Given> {
    private final BlockBuilder blockBuilder;
    private final BodyReader bodyReader;
    private final BodyParser bodyParser;

    MessagingBodyGiven(BlockBuilder blockBuilder, BodyReader bodyReader, BodyParser bodyParser) {
        this.blockBuilder = blockBuilder;
        this.bodyReader = bodyReader;
        this.bodyParser = bodyParser;
    }

    @Override
    public MethodVisitor<Given> apply(SingleContractMetadata metadata) {
        this.appendBodyGiven(metadata);
        return this;
    }

    private void appendBodyGiven(SingleContractMetadata metadata) {
        Input inputMessage;
        ContentType contentType = metadata.getInputTestContentType();
        Object bodyValue = this.bodyParser.extractServerValueFromBody(contentType, (inputMessage = metadata.getContract().getInput()).getMessageBody().getServerValue());
        if (bodyValue instanceof FromFileProperty) {
            FromFileProperty fileProperty = (FromFileProperty)bodyValue;
            String byteText = fileProperty.isByte() ? this.bodyReader.readBytesFromFileString(metadata, fileProperty, CommunicationType.REQUEST) : this.bodyParser.quotedLongText(this.bodyReader.readStringFromFileString(metadata, fileProperty, CommunicationType.REQUEST));
            this.blockBuilder.addIndented(byteText);
        } else {
            String text = this.bodyParser.convertToJsonString(bodyValue);
            this.blockBuilder.addIndented(this.bodyParser.quotedEscapedLongText(text));
        }
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        return metadata.getContract().getInput().getMessageBody() != null;
    }
}

