/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyMethodVisitor;
import org.springframework.cloud.contract.verifier.builder.CustomModeAcceptor;
import org.springframework.cloud.contract.verifier.builder.CustomModeResponseWhen;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.When;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class CustomModeWhen
implements When,
BodyMethodVisitor,
CustomModeAcceptor {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final List<When> responseWhens = new LinkedList<When>();

    CustomModeWhen(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
        this.responseWhens.addAll(Arrays.asList(new CustomModeResponseWhen(blockBuilder, this.generatedClassMetaData)));
    }

    @Override
    public MethodVisitor<When> apply(SingleContractMetadata singleContractMetadata) {
        this.startBodyBlock(this.blockBuilder, "when:");
        this.addResponseWhenLine(singleContractMetadata);
        this.blockBuilder.addEmptyLine();
        return this;
    }

    private void addResponseWhenLine(SingleContractMetadata singleContractMetadata) {
        this.responseWhens.stream().filter(when -> when.accept(singleContractMetadata)).findFirst().orElseThrow(() -> new IllegalStateException("No matching request building When implementation for Rest Assured")).apply(singleContractMetadata);
    }

    @Override
    public boolean accept(SingleContractMetadata singleContractMetadata) {
        return this.acceptType(this.generatedClassMetaData, singleContractMetadata);
    }
}

