/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyMethodVisitor;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.GenericBinaryBodyThen;
import org.springframework.cloud.contract.verifier.builder.GenericJsonBodyThen;
import org.springframework.cloud.contract.verifier.builder.GenericTextBodyThen;
import org.springframework.cloud.contract.verifier.builder.GenericXmlBodyThen;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.Then;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.template.HandlebarsTemplateProcessor;
import org.springframework.cloud.contract.verifier.template.TemplateProcessor;

class GenericHttpBodyThen
implements Then,
BodyMethodVisitor {
    private final BlockBuilder blockBuilder;
    private final BodyParser bodyParser;
    private final TemplateProcessor templateProcessor;
    private final ComparisonBuilder comparisonBuilder;
    private final List<Then> thens = new LinkedList<Then>();

    GenericHttpBodyThen(BlockBuilder blockBuilder, GeneratedClassMetaData metaData, BodyParser bodyParser, ComparisonBuilder comparisonBuilder) {
        this.blockBuilder = blockBuilder;
        this.bodyParser = bodyParser;
        this.comparisonBuilder = comparisonBuilder;
        this.templateProcessor = new HandlebarsTemplateProcessor();
        this.thens.addAll(Arrays.asList(new GenericBinaryBodyThen(blockBuilder, metaData, this.bodyParser, comparisonBuilder), new GenericTextBodyThen(blockBuilder, metaData, this.bodyParser, this.comparisonBuilder), new GenericJsonBodyThen(blockBuilder, metaData, this.bodyParser, this.comparisonBuilder), new GenericXmlBodyThen(blockBuilder, this.bodyParser)));
    }

    @Override
    public MethodVisitor<Then> apply(SingleContractMetadata metadata) {
        this.endBodyBlock(this.blockBuilder);
        this.blockBuilder.addEmptyLine();
        this.startBodyBlock(this.blockBuilder, "and:");
        this.thens.stream().filter(then -> then.accept(metadata)).forEach(then -> then.apply(metadata));
        return this;
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        return metadata.getContract().getResponse().getBody() != null;
    }
}

