/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.servlet.WireMockHandlerDispatchingServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.autoconfigure.context.ConfigurationPropertiesAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.autoconfigure.web.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerPropertiesAutoConfiguration;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.contract.wiremock.ContainerConfiguration;
import org.springframework.cloud.contract.wiremock.ContainerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.context.ServletContextAware;

@Configuration
@Import(value={ContainerConfiguration.TomcatContainerConfiguration.class, ContainerConfiguration.JettyContainerConfiguration.class, ContainerConfiguration.UndertowContainerConfiguration.class, ServerPropertiesAutoConfiguration.class, EmbeddedServletContainerAutoConfiguration.BeanPostProcessorsRegistrar.class, ConfigurationPropertiesAutoConfiguration.class, JacksonAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class, PropertyPlaceholderAutoConfiguration.class, ContainerProperties.class})
class WiremockServerConfiguration {
    @Autowired
    private AdminRequestHandler adminRequestHandler;
    @Autowired
    private StubRequestHandler stubRequestHandler;
    @Autowired
    private Options options;

    WiremockServerConfiguration() {
    }

    @Bean(name={"dispatcherServletRegistration"})
    public ServletRegistrationBean stubServletRegistration() {
        ServletRegistrationBean reg = new ServletRegistrationBean();
        reg.addInitParameter("RequestHandlerClass", StubRequestHandler.class.getName());
        reg.setServlet((Servlet)new WireMockHandlerDispatchingServlet());
        reg.setName("stub");
        reg.addUrlMappings(new String[]{"/"});
        return reg;
    }

    @Bean
    public ServletRegistrationBean adminServletRegistration() {
        ServletRegistrationBean reg = new ServletRegistrationBean();
        reg.addInitParameter("RequestHandlerClass", AdminRequestHandler.class.getName());
        reg.setServlet((Servlet)new WireMockHandlerDispatchingServlet());
        reg.setName("admin");
        reg.addUrlMappings(new String[]{"/__admin/*"});
        return reg;
    }

    @Bean
    public ServletContextAware servletContextSetUp() {
        return new ServletContextAware(){

            public void setServletContext(ServletContext servletContext) {
                servletContext.setAttribute(AdminRequestHandler.class.getName(), (Object)WiremockServerConfiguration.this.adminRequestHandler);
                servletContext.setAttribute(StubRequestHandler.class.getName(), (Object)WiremockServerConfiguration.this.stubRequestHandler);
                servletContext.setAttribute("Notifier", (Object)WiremockServerConfiguration.this.options.notifier());
            }
        };
    }
}

