/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.MultiValue;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MatchesJsonPathPattern;
import com.github.tomakehurst.wiremock.matching.MatchesXPathPattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.web.client.MockRestServiceServer;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.test.web.client.match.MockRestRequestMatchers;
import org.springframework.test.web.client.response.DefaultResponseCreator;
import org.springframework.test.web.client.response.MockRestResponseCreators;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class WireMockRestServiceServer {
    private final PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private String suffix = ".json";
    private String baseUrl = "";
    private MockRestServiceServer.MockRestServiceServerBuilder builder;
    private List<String> locations = new ArrayList<String>();
    private List<String> files = new ArrayList<String>();
    private boolean ignoreExpectOrder = true;

    private WireMockRestServiceServer(RestTemplate restTemplate) {
        this.builder = MockRestServiceServer.bindTo((RestTemplate)restTemplate);
    }

    public static WireMockRestServiceServer with(RestTemplate restTemplate) {
        return new WireMockRestServiceServer(restTemplate);
    }

    public WireMockRestServiceServer ignoreExpectOrder(boolean ignoreExpectOrder) {
        this.ignoreExpectOrder = ignoreExpectOrder;
        return this;
    }

    public WireMockRestServiceServer suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public WireMockRestServiceServer baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public WireMockRestServiceServer stubs(String ... locations) {
        this.locations.addAll(Arrays.asList(locations));
        return this;
    }

    public WireMockRestServiceServer files(String ... locations) {
        this.files.addAll(Arrays.asList(locations));
        return this;
    }

    public MockRestServiceServer build() {
        if (this.ignoreExpectOrder) {
            this.builder.ignoreExpectOrder(true);
        }
        MockRestServiceServer server = this.builder.build();
        ArrayList<StubMapping> mappings = new ArrayList<StubMapping>();
        for (String location : this.locations) {
            try {
                for (Resource resource : this.resolver.getResources(this.pattern(location))) {
                    StubMapping mapping = this.mapping(resource);
                    mappings.add(mapping);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load resources for: " + location, e);
            }
        }
        if (this.ignoreExpectOrder) {
            Collections.sort(mappings, new StubMappingComparator());
        }
        for (StubMapping mapping : mappings) {
            ResponseActions expect = server.expect(MockRestRequestMatchers.requestTo((String)this.request(mapping.getRequest())));
            expect.andExpect(MockRestRequestMatchers.method((HttpMethod)HttpMethod.valueOf((String)mapping.getRequest().getMethod().getName())));
            mapping.getRequest().getBodyPatterns();
            this.bodyPatterns(expect, mapping.getRequest());
            this.requestHeaders(expect, mapping.getRequest());
            expect.andRespond((ResponseCreator)this.response(mapping.getResponse()));
        }
        return server;
    }

    private void bodyPatterns(ResponseActions expect, RequestPattern request) {
        if (request.getBodyPatterns() == null) {
            return;
        }
        for (StringValuePattern pattern : request.getBodyPatterns()) {
            if (pattern instanceof MatchesJsonPathPattern) {
                expect.andExpect(MockRestRequestMatchers.jsonPath((String)((MatchesJsonPathPattern)pattern).getMatchesJsonPath(), (Object[])new Object[0]).exists());
            } else if (pattern instanceof MatchesXPathPattern) {
                expect.andExpect(this.xpath((MatchesXPathPattern)pattern));
            }
            expect.andExpect(this.matchContents(pattern));
        }
    }

    private RequestMatcher matchContents(final StringValuePattern pattern) {
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws IOException, AssertionError {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
                MatchResult result = pattern.match((Object)mockRequest.getBodyAsString());
                MatcherAssert.assertThat((String)("Request as string [" + mockRequest.getBodyAsString() + "]"), (boolean)result.isExactMatch());
            }
        };
    }

    private RequestMatcher xpath(MatchesXPathPattern pattern) {
        try {
            return MockRestRequestMatchers.xpath((String)pattern.getMatchesXPath(), (Object[])new Object[0]).exists();
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
    }

    private String request(RequestPattern request) {
        return this.baseUrl + (request.getUrlPath() == null ? (request.getUrl() == null ? "/" : request.getUrl()) : request.getUrlPath());
    }

    private String pattern(String location) {
        if (!StringUtils.getFilename((String)location).contains(".") && !location.contains("*")) {
            if (!location.endsWith("/")) {
                location = location + "/";
            }
            location = location + "**/*" + this.suffix;
        }
        return location;
    }

    private StubMapping mapping(Resource resource) throws IOException {
        return (StubMapping)Json.read((String)StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)Charset.defaultCharset()), StubMapping.class);
    }

    private DefaultResponseCreator response(ResponseDefinition response) {
        return MockRestResponseCreators.withStatus((HttpStatus)HttpStatus.valueOf((int)response.getStatus())).body(this.body(response)).contentType(this.contentType(response)).headers(this.responseHeaders(response));
    }

    private String body(ResponseDefinition response) {
        if (response.getBody() != null) {
            return response.getBody();
        }
        String file = response.getBodyFileName();
        if (file != null) {
            List<String> locations = this.files.isEmpty() ? Arrays.asList("classpath:/__files/") : this.files;
            for (String location : locations) {
                try {
                    if (!location.endsWith("/")) {
                        location = location + "/";
                    }
                    for (Resource files : this.resolver.getResources(location)) {
                        if (!files.exists()) continue;
                        try {
                            Resource resource = files.createRelative(file);
                            if (!resource.exists()) continue;
                            return StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)Charset.forName("UTF-8"));
                        }
                        catch (IOException e) {
                            throw new IllegalStateException("Cannot locate body file: " + file, e);
                        }
                    }
                }
                catch (IOException iOException) {
                }
            }
        }
        return "";
    }

    private void requestHeaders(ResponseActions expect, RequestPattern request) {
        if (request.getHeaders() != null) {
            for (final String header : request.getHeaders().keySet()) {
                final MultiValuePattern pattern = (MultiValuePattern)request.getHeaders().get(header);
                expect.andExpect(MockRestRequestMatchers.header((String)header, (Matcher[])new Matcher[]{new BaseMatcher<String>(){

                    public boolean matches(Object item) {
                        return pattern.match(new MultiValue(header, Arrays.asList((String)item))).isExactMatch();
                    }

                    public void describeTo(Description description) {
                        description.appendText("should match header: " + header + " with ").appendText(pattern.getExpected());
                    }
                }}));
            }
        }
    }

    private HttpHeaders responseHeaders(ResponseDefinition response) {
        HttpHeaders headers = new HttpHeaders();
        if (response.getHeaders() != null) {
            for (HttpHeader header : response.getHeaders().all()) {
                if (header.keyEquals("Content-Type")) continue;
                for (String value : header.values()) {
                    headers.add(header.key(), value);
                }
            }
        }
        return headers;
    }

    private MediaType contentType(ResponseDefinition response) {
        HttpHeader header;
        String value = null;
        if (response.getHeaders() != null && (header = response.getHeaders().getHeader("Content-Type")) != null && header.isPresent()) {
            value = header.firstValue();
        }
        return value == null ? MediaType.TEXT_PLAIN : MediaType.valueOf(value);
    }

    private static class StubMappingComparator
    implements Comparator<StubMapping> {
        private StubMappingComparator() {
        }

        @Override
        public int compare(StubMapping one, StubMapping two) {
            if (one == two) {
                return 0;
            }
            int value = this.request(one.getRequest()).compareTo(this.request(two.getRequest()));
            if (value == 0) {
                if (one.getPriority() != null) {
                    if (two.getPriority() != null) {
                        return one.getPriority().compareTo(two.getPriority());
                    }
                    return -one.getPriority().intValue();
                }
                if (two.getPriority() != null) {
                    return -two.getPriority().intValue();
                }
                int twos = 0;
                if (two.getRequest().getHeaders() != null) {
                    twos = two.getRequest().getHeaders().size();
                }
                int ones = 0;
                if (one.getRequest().getHeaders() != null) {
                    ones = one.getRequest().getHeaders().size();
                }
                if ((value = twos - ones) == 0) {
                    if (two.getPriority() != null) {
                        return one.getPriority() != null ? one.getPriority() - two.getPriority() : 1;
                    }
                    value = (int)(one.getInsertionIndex() - two.getInsertionIndex());
                }
            }
            return value;
        }

        private String request(RequestPattern request) {
            return request.getUrlPath() == null ? (request.getUrl() == null ? "/" : request.getUrl()) : request.getUrlPath();
        }
    }
}

