/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock.restdocs;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.servlet.WireMockHttpServletRequestAdapter;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.springframework.cloud.contract.wiremock.restdocs.JsonPathValue;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.restdocs.mockmvc.MockMvcRestDocumentation;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class ContractRequestHandler
implements ResultHandler {
    static final String ATTRIBUTE_NAME_CONFIGURATION = "org.springframework.restdocs.configuration";
    private Map<String, JsonPath> jsonPaths = new LinkedHashMap<String, JsonPath>();
    private MediaType contentType;
    private String name;
    private MappingBuilder builder;

    public ResultHandler stub(String name) {
        this.name = name;
        return this;
    }

    public void handle(MvcResult result) throws Exception {
        MockHttpServletRequest request = result.getRequest();
        Map<String, Object> configuration = this.getConfiguration(result);
        String actual = StreamUtils.copyToString((InputStream)request.getInputStream(), (Charset)Charset.forName("UTF-8"));
        for (JsonPath jsonPath : this.jsonPaths.values()) {
            new JsonPathValue(jsonPath, actual).assertHasValue(Object.class, "an object");
        }
        configuration.put("contract.jsonPaths", this.jsonPaths.keySet());
        if (this.contentType != null) {
            configuration.put("contract.contentType", this.contentType);
            String resultType = request.getContentType();
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)resultType).isNotNull()).as("no content type", new Object[0]);
            Assertions.assertThat((boolean)this.contentType.includes(MediaType.valueOf((String)resultType))).isTrue().as("content type did not match", new Object[0]);
        }
        if (this.builder != null) {
            this.builder.willReturn(this.getResponseDefinition(result));
            StubMapping stubMapping = this.builder.build();
            MatchResult match = stubMapping.getRequest().match((Request)new WireMockHttpServletRequestAdapter((HttpServletRequest)request));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)match.isExactMatch()).as("wiremock did not match request", new Object[0])).isTrue();
            configuration.put("contract.stubMapping", stubMapping);
        }
        MockMvcRestDocumentation.document((String)this.name, (Snippet[])new Snippet[0]).handle(result);
    }

    private ResponseDefinitionBuilder getResponseDefinition(MvcResult result) throws UnsupportedEncodingException {
        MockHttpServletResponse response = result.getResponse();
        ResponseDefinitionBuilder definition = ResponseDefinitionBuilder.responseDefinition().withBody(response.getContentAsString()).withStatus(response.getStatus());
        this.addResponseHeaders(definition, response);
        return definition;
    }

    private void addResponseHeaders(ResponseDefinitionBuilder definition, MockHttpServletResponse input) {
        for (String name : input.getHeaderNames()) {
            definition.withHeader(name, new String[]{input.getHeader(name)});
        }
    }

    private Map<String, Object> getConfiguration(MvcResult result) {
        HashMap map = (HashMap)result.getRequest().getAttribute(ATTRIBUTE_NAME_CONFIGURATION);
        if (map == null) {
            map = new HashMap();
            result.getRequest().setAttribute(ATTRIBUTE_NAME_CONFIGURATION, map);
        }
        return map;
    }

    public ContractRequestHandler wiremock(MappingBuilder builder) {
        this.builder = builder;
        return this;
    }

    public ContractRequestHandler jsonPath(String expression, Object ... args) {
        this.compile(expression, args);
        return this;
    }

    public ContractRequestHandler contentType(MediaType contentType) {
        this.contentType = contentType;
        return this;
    }

    private void compile(String expression, Object ... args) {
        Assert.hasText((String)(expression == null ? null : expression), (String)"expression must not be null or empty");
        expression = String.format(expression, args);
        this.jsonPaths.put(expression, JsonPath.compile((String)expression, (Predicate[])new Predicate[0]));
    }
}

