/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class WireMockRestTemplateConfiguration {
    @Bean
    @ConditionalOnClass(value={SSLContextBuilder.class})
    public RestTemplateCustomizer restTemplateCustomizer() {
        return new RestTemplateCustomizer(){

            public void customize(RestTemplate restTemplate) {
                if (restTemplate.getRequestFactory() instanceof HttpComponentsClientHttpRequestFactory) {
                    HttpComponentsClientHttpRequestFactory factory = (HttpComponentsClientHttpRequestFactory)restTemplate.getRequestFactory();
                    factory.setHttpClient(this.createSslHttpClient());
                }
            }

            private HttpClient createSslHttpClient() {
                try {
                    SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)TrustSelfSignedStrategy.INSTANCE).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                    return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).build();
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Unable to create SSL HttpClient", ex);
                }
            }
        };
    }
}

