/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.Slf4jNotifier;
import com.github.tomakehurst.wiremock.core.Options;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.contract.wiremock.WireMockConfigurationCustomizer;
import org.springframework.cloud.contract.wiremock.WireMockProperties;
import org.springframework.cloud.contract.wiremock.WireMockSpring;
import org.springframework.cloud.contract.wiremock.WireMockStubMapping;
import org.springframework.cloud.contract.wiremock.file.ResourcesFileSource;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={WireMockProperties.class})
public class WireMockConfiguration
implements SmartLifecycle {
    private static final Log log = LogFactory.getLog(WireMockConfiguration.class);
    static final String WIREMOCK_SERVER_BEAN_NAME = "wireMockServer";
    private volatile boolean running;
    private WireMockServer server;
    @Autowired(required=false)
    private Options options;
    @Autowired(required=false)
    private WireMockConfigurationCustomizer customizer;
    @Autowired
    private DefaultListableBeanFactory beanFactory;
    @Autowired
    private WireMockProperties wireMock;
    @Autowired
    private ResourceLoader resourceLoader;

    @PostConstruct
    public void init() throws IOException {
        if (this.options == null) {
            com.github.tomakehurst.wiremock.core.WireMockConfiguration factory = WireMockSpring.options();
            if (this.wireMock.getServer().getPort() != 8080) {
                factory.port(this.wireMock.getServer().getPort());
            }
            if (this.wireMock.getServer().getHttpsPort() != -1) {
                factory.httpsPort(Integer.valueOf(this.wireMock.getServer().getHttpsPort()));
            }
            this.registerFiles(factory);
            factory.notifier((Notifier)new Slf4jNotifier(true));
            this.options = factory;
            if (this.customizer != null) {
                this.customizer.customize(factory);
            }
        }
        if (this.server == null) {
            this.server = new WireMockServer(this.options);
        }
        this.registerStubs();
        if (log.isDebugEnabled()) {
            log.debug((Object)("WireMock server has [" + this.server.getStubMappings().size() + "] registered"));
        }
        if (!this.beanFactory.containsBean(WIREMOCK_SERVER_BEAN_NAME)) {
            this.beanFactory.registerSingleton(WIREMOCK_SERVER_BEAN_NAME, (Object)this.server);
        }
    }

    private void registerStubs() throws IOException {
        for (String stubs : this.wireMock.getServer().getStubs()) {
            if (!StringUtils.hasText((String)stubs)) continue;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
            String pattern = stubs;
            if (!pattern.contains("*")) {
                if (!pattern.endsWith("/")) {
                    pattern = pattern + "/";
                }
                pattern = pattern + "**/*.json";
            }
            for (Resource resource : resolver.getResources(pattern)) {
                this.server.addStubMapping(WireMockStubMapping.buildFrom(StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)Charset.forName("UTF-8"))));
            }
        }
    }

    void reset() {
        this.server.resetAll();
    }

    private void registerFiles(com.github.tomakehurst.wiremock.core.WireMockConfiguration factory) throws IOException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String files : this.wireMock.getServer().getFiles()) {
            if (!StringUtils.hasText((String)files)) continue;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
            for (Resource resource : resolver.getResources(files)) {
                if (!resource.exists()) continue;
                resources.add(resource);
            }
        }
        if (!resources.isEmpty()) {
            ResourcesFileSource fileSource = new ResourcesFileSource(resources.toArray(new Resource[0]));
            factory.fileSource((FileSource)fileSource);
        }
    }

    public void start() {
        this.server.start();
        WireMock.configureFor((String)"localhost", (int)this.server.port());
        this.running = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started WireMock at port [" + this.server.port() + "]. It has [" + this.server.getStubMappings().size() + "] mappings registered"));
        }
        Assert.isTrue((boolean)new RestTemplate().getForEntity("http://localhost:" + this.server.port() + "/__admin/mappings", String.class, new Object[0]).getStatusCode().is2xxSuccessful(), (String)"__admin/mappings endpoint wasn't accessible");
    }

    public void stop() {
        if (this.running) {
            this.server.stop();
            this.running = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Stopped WireMock instance");
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 0;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }
}

