/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock.restdocs;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.servlet.WireMockHttpServletRequestAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.contract.wiremock.restdocs.WireMockVerifyHelper;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.restdocs.mockmvc.MockMvcRestDocumentation;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.util.StreamUtils;

public class ContractResultHandler
extends WireMockVerifyHelper<MvcResult, ContractResultHandler>
implements ResultHandler {
    static final String ATTRIBUTE_NAME_CONFIGURATION = "org.springframework.restdocs.configuration";

    public void handle(MvcResult result) throws Exception {
        this.configure(result);
        MockMvcRestDocumentation.document((String)this.getName(), (Snippet[])new Snippet[0]).handle(result);
    }

    @Override
    protected ResponseDefinitionBuilder getResponseDefinition(MvcResult result) {
        MockHttpServletResponse response = result.getResponse();
        try {
            ResponseDefinitionBuilder definition = ResponseDefinitionBuilder.responseDefinition().withBody(response.getContentAsString()).withStatus(response.getStatus());
            this.addResponseHeaders(definition, response);
            return definition;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Cannot create response body", e);
        }
    }

    private void addResponseHeaders(ResponseDefinitionBuilder definition, MockHttpServletResponse input) {
        for (String name : input.getHeaderNames()) {
            definition.withHeader(name, new String[]{input.getHeader(name)});
        }
    }

    @Override
    protected Map<String, Object> getConfiguration(MvcResult result) {
        HashMap map = (HashMap)result.getRequest().getAttribute(ATTRIBUTE_NAME_CONFIGURATION);
        if (map == null) {
            map = new HashMap();
            result.getRequest().setAttribute(ATTRIBUTE_NAME_CONFIGURATION, map);
        }
        return map;
    }

    @Override
    protected Request getWireMockRequest(MvcResult result) {
        return new WireMockHttpServletRequestAdapter((HttpServletRequest)result.getRequest());
    }

    @Override
    protected MediaType getContentType(MvcResult result) {
        return MediaType.valueOf((String)result.getRequest().getContentType());
    }

    @Override
    protected byte[] getRequestBodyContent(MvcResult result) {
        try {
            return StreamUtils.copyToByteArray((InputStream)result.getRequest().getInputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create request body", e);
        }
    }
}

