/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock.restdocs;

import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.OperationResponseFactory;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessor;

class DynamicPortPlaceholderInserterPreprocessor
implements OperationPreprocessor {
    private final OperationResponseFactory responseFactory = new OperationResponseFactory();

    DynamicPortPlaceholderInserterPreprocessor() {
    }

    public OperationRequest preprocess(OperationRequest request) {
        return request;
    }

    public OperationResponse preprocess(OperationResponse response) {
        String content = response.getContentAsString();
        if (content.contains("localhost:8080")) {
            content = content.replace("localhost:8080", "localhost:{{request.requestLine.port}}");
            response = this.responseFactory.createFrom(response, content.getBytes());
        }
        return response;
    }
}

