/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.HashSet;
import java.util.List;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingRecoveryStrategy;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.registry.AppRegistration;
import org.springframework.cloud.dataflow.registry.AppRegistry;
import org.springframework.core.io.Resource;

class ConfigurationPropertyNameAfterDashDashRecoveryStrategy
extends StacktraceFingerprintingRecoveryStrategy<CheckPointedParseException> {
    private final AppRegistry appRegistry;
    private final ApplicationConfigurationMetadataResolver metadataResolver;

    ConfigurationPropertyNameAfterDashDashRecoveryStrategy(AppRegistry appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        super(CheckPointedParseException.class, "file --", "file | foo --");
        this.appRegistry = appRegistry;
        this.metadataResolver = metadataResolver;
    }

    @Override
    public void addProposals(String dsl, CheckPointedParseException exception, int detailLevel, List<CompletionProposal> collector) {
        ApplicationType appType;
        String safe = exception.getExpressionStringUntilCheckpoint();
        StreamDefinition streamDefinition = new StreamDefinition("__dummy", safe);
        StreamAppDefinition lastApp = (StreamAppDefinition)streamDefinition.getDeploymentOrderIterator().next();
        String lastAppName = lastApp.getName();
        AppRegistration lastAppRegistration = null;
        ApplicationType[] applicationTypeArray = CompletionUtils.determinePotentialTypes(lastApp);
        int n = applicationTypeArray.length;
        for (int i = 0; i < n && (lastAppRegistration = this.appRegistry.find(lastAppName, appType = applicationTypeArray[i])) == null; ++i) {
        }
        if (lastAppRegistration == null) {
            return;
        }
        HashSet alreadyPresentOptions = new HashSet(lastApp.getProperties().keySet());
        Resource jarFile = lastAppRegistration.getResource();
        CompletionProposal.Factory proposals = CompletionProposal.expanding(dsl);
        for (ConfigurationMetadataProperty property : this.metadataResolver.listProperties(jarFile)) {
            if (alreadyPresentOptions.contains(property.getName())) continue;
            collector.add(proposals.withSuffix(property.getName() + "=", property.getShortDescription()));
        }
        if (detailLevel > 1) {
            for (ConfigurationMetadataProperty property : this.metadataResolver.listProperties(jarFile, true)) {
                if (alreadyPresentOptions.contains(property.getId())) continue;
                collector.add(proposals.withSuffix(property.getId() + "=", property.getShortDescription()));
            }
        }
    }
}

