/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.io.IOException;
import java.net.URLClassLoader;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ValueHint;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingTaskRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.ValueHintProvider;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.TaskDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;
import org.springframework.cloud.dataflow.registry.AppRegistration;
import org.springframework.cloud.dataflow.registry.AppRegistry;
import org.springframework.core.io.Resource;

public class ConfigurationPropertyValueHintTaskRecoveryStrategy
extends StacktraceFingerprintingTaskRecoveryStrategy<CheckPointedParseException> {
    private final AppRegistry appRegistry;
    private final ApplicationConfigurationMetadataResolver metadataResolver;
    @Autowired
    private ValueHintProvider[] valueHintProviders = new ValueHintProvider[0];

    ConfigurationPropertyValueHintTaskRecoveryStrategy(AppRegistry appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        super(CheckPointedParseException.class, "foo --bar=");
        this.appRegistry = appRegistry;
        this.metadataResolver = metadataResolver;
    }

    @Override
    public void addProposals(String dsl, CheckPointedParseException exception, int detailLevel, List<CompletionProposal> collector) {
        String propertyName = this.recoverPropertyName(exception);
        AppRegistration appRegistration = this.lookupLastApp(exception);
        if (appRegistration == null) {
            return;
        }
        Resource appResource = appRegistration.getResource();
        CompletionProposal.Factory proposals = CompletionProposal.expanding(dsl);
        List whiteList = this.metadataResolver.listProperties(appResource);
        URLClassLoader classLoader = null;
        try {
            for (ConfigurationMetadataProperty property : this.metadataResolver.listProperties(appResource, true)) {
                if (!CompletionUtils.isMatchingProperty(propertyName, property, whiteList)) continue;
                if (classLoader == null) {
                    classLoader = this.metadataResolver.createAppClassLoader(appResource);
                }
                for (ValueHintProvider valueHintProvider : this.valueHintProviders) {
                    for (ValueHint valueHint : valueHintProvider.generateValueHints(property, classLoader)) {
                        collector.add(proposals.withSuffix(String.valueOf(valueHint.getValue()), valueHint.getShortDescription()));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (classLoader != null) {
                try {
                    classLoader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private AppRegistration lookupLastApp(CheckPointedParseException exception) {
        String safe = exception.getExpressionStringUntilCheckpoint();
        TaskDefinition taskDefinition = new TaskDefinition("__dummy", safe);
        String appName = taskDefinition.getRegisteredAppName();
        AppRegistration appRegistration = this.appRegistry.find(appName, ApplicationType.task);
        return appRegistration;
    }

    private String recoverPropertyName(CheckPointedParseException exception) {
        List tokens = exception.getTokens();
        int tokenPointer = tokens.size() - 1;
        while (!((Token)tokens.get(tokenPointer - 1)).isKind(TokenKind.DOUBLE_MINUS)) {
            --tokenPointer;
        }
        int equalSignPointer = tokens.size() - 1;
        StringBuilder builder = new StringBuilder();
        while (tokenPointer < equalSignPointer) {
            Token t = (Token)tokens.get(tokenPointer);
            if (t.isIdentifier()) {
                builder.append(t.stringValue());
            } else {
                builder.append(t.getKind().getTokenChars());
            }
            ++tokenPointer;
        }
        return builder.toString();
    }
}

