/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingRecoveryStrategy;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.registry.AppRegistration;
import org.springframework.cloud.dataflow.registry.AppRegistry;

class EmptyStartYieldsSourceAppsRecoveryStrategy
extends StacktraceFingerprintingRecoveryStrategy<IllegalArgumentException> {
    private final AppRegistry registry;

    public EmptyStartYieldsSourceAppsRecoveryStrategy(AppRegistry registry) {
        super(IllegalArgumentException.class, "");
        this.registry = registry;
    }

    @Override
    public void addProposals(String dsl, IllegalArgumentException exception, int detailLevel, List<CompletionProposal> proposals) {
        CompletionProposal.Factory completionFactory = CompletionProposal.expanding(dsl);
        for (AppRegistration app : this.registry.findAll()) {
            if (app.getType() != ApplicationType.source) continue;
            proposals.add(completionFactory.withSeparateTokens(app.getName(), "Start with a source app"));
        }
    }
}

