/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.ConfigurationPropertyNameAfterDashDashTaskRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingTaskRecoveryStrategy;
import org.springframework.cloud.dataflow.core.TaskDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.core.dsl.ParseException;
import org.springframework.util.Assert;

class ExpandOneDashToTwoDashesTaskRecoveryStrategy
extends StacktraceFingerprintingTaskRecoveryStrategy<ParseException> {
    @Autowired
    private ConfigurationPropertyNameAfterDashDashTaskRecoveryStrategy recoveryAfterDashDash;

    public ExpandOneDashToTwoDashesTaskRecoveryStrategy() {
        super(ParseException.class, "file -");
    }

    @Override
    public void addProposals(String dsl, ParseException exception, int detailLevel, List<CompletionProposal> proposals) {
        String withDashDash = dsl + "-";
        try {
            new TaskDefinition("__dummy", withDashDash);
        }
        catch (CheckPointedParseException recoverable) {
            Assert.isTrue((boolean)this.recoveryAfterDashDash.shouldTrigger(withDashDash, (Exception)((Object)recoverable)));
            this.recoveryAfterDashDash.addProposals(withDashDash, recoverable, detailLevel, proposals);
        }
    }
}

