/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client;

import java.util.List;
import java.util.Map;
import org.springframework.cloud.dataflow.rest.client.SchedulerOperations;
import org.springframework.cloud.dataflow.rest.resource.ScheduleInfoResource;
import org.springframework.cloud.dataflow.rest.util.DeploymentPropertiesUtils;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

public class SchedulerTemplate
implements SchedulerOperations {
    public static final String SCHEDULES_RELATION = "tasks/schedules";
    private static final String SCHEDULES_INSTANCE_RELATION = "tasks/schedules/instances";
    private final RestTemplate restTemplate;
    private final Link schedulesLink;
    private final Link schedulesInstanceLink;

    SchedulerTemplate(RestTemplate restTemplate, ResourceSupport resources) {
        Assert.notNull((Object)resources, (String)"URI Resources must not be be null");
        Assert.notNull((Object)resources.getLink(SCHEDULES_RELATION), (String)"Schedules relation is required");
        Assert.notNull((Object)resources.getLink(SCHEDULES_INSTANCE_RELATION), (String)"Schedules instance relation is required");
        Assert.notNull((Object)restTemplate, (String)"RestTemplate must not be null");
        this.restTemplate = restTemplate;
        this.schedulesLink = resources.getLink(SCHEDULES_RELATION);
        this.schedulesInstanceLink = resources.getLink(SCHEDULES_INSTANCE_RELATION);
    }

    @Override
    public void schedule(String scheduleName, String taskDefinitionName, Map<String, String> taskProperties, List<String> commandLineArgs) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        values.add((Object)"scheduleName", (Object)scheduleName);
        values.add((Object)"properties", (Object)DeploymentPropertiesUtils.format(taskProperties));
        values.add((Object)"taskDefinitionName", (Object)taskDefinitionName);
        values.add((Object)"arguments", commandLineArgs);
        this.restTemplate.postForObject(this.schedulesLink.getHref(), (Object)values, Long.class, new Object[0]);
    }

    @Override
    public void unschedule(String scheduleName) {
        this.restTemplate.delete(this.schedulesLink.getHref() + "/" + scheduleName, new Object[0]);
    }

    @Override
    public PagedResources<ScheduleInfoResource> list(String taskDefinitionName) {
        return (PagedResources)this.restTemplate.getForObject(this.schedulesInstanceLink.expand(new Object[]{taskDefinitionName}).getHref(), ScheduleInfoResource.Page.class, new Object[0]);
    }

    @Override
    public PagedResources<ScheduleInfoResource> list() {
        return (PagedResources)this.restTemplate.getForObject(this.schedulesLink.getHref(), ScheduleInfoResource.Page.class, new Object[0]);
    }

    @Override
    public ScheduleInfoResource getSchedule(String scheduleName) {
        return (ScheduleInfoResource)this.restTemplate.getForObject(this.schedulesLink.getHref() + "/" + scheduleName, ScheduleInfoResource.class, new Object[0]);
    }
}

