/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.resource.support;

import java.io.File;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.deployer.resource.support.DelegatingResourceLoader;
import org.springframework.cloud.deployer.resource.support.LRUCleaningResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class LRUCleaningResourceLoaderBeanPostProcessor
implements BeanPostProcessor {
    private final float targetFreeSpaceRatio;
    private final File repositoryCache;

    public LRUCleaningResourceLoaderBeanPostProcessor(float targetFreeSpaceRatio, File repositoryCache) {
        this.targetFreeSpaceRatio = targetFreeSpaceRatio;
        this.repositoryCache = repositoryCache;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DelegatingResourceLoader) {
            return new LRUCleaningResourceLoader((ResourceLoader)bean, this.targetFreeSpaceRatio, this.repositoryCache);
        }
        return bean;
    }
}

