/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.azure;

import com.microsoft.azure.functions.spi.inject.FunctionInstanceInjector;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.cloud.function.adapter.azure.FunctionInvoker;
import org.springframework.cloud.function.context.FunctionalSpringApplication;
import org.springframework.cloud.function.utils.FunctionClassUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class AzureFunctionInstanceInjector
implements FunctionInstanceInjector {
    private static Log logger = LogFactory.getLog(AzureFunctionInstanceInjector.class);
    private static ConfigurableApplicationContext APPLICATION_CONTEXT;

    public <T> T getInstance(Class<T> functionClass) throws Exception {
        try {
            if (ClassUtils.isAssignable(FunctionInvoker.class, functionClass)) {
                return functionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            AzureFunctionInstanceInjector.initialize();
            Map azureFunctionBean = APPLICATION_CONTEXT.getBeansOfType(functionClass);
            if (CollectionUtils.isEmpty((Map)azureFunctionBean)) {
                throw new IllegalStateException("Failed to retrieve Bean instance for: " + functionClass + ". The class should be annotated with @Component to let the Spring framework initialize it!");
            }
            return (T)azureFunctionBean.entrySet().iterator().next().getValue();
        }
        catch (Exception e) {
            if (APPLICATION_CONTEXT != null) {
                APPLICATION_CONTEXT.close();
            }
            throw new IllegalStateException("Failed to initialize", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        String string = AzureFunctionInstanceInjector.class.getName();
        synchronized (string) {
            if (APPLICATION_CONTEXT == null) {
                Class springConfigurationClass = FunctionClassUtils.getStartClass();
                logger.info((Object)("Initializing: " + springConfigurationClass));
                APPLICATION_CONTEXT = AzureFunctionInstanceInjector.springApplication(springConfigurationClass).run(new String[0]);
            }
        }
    }

    private static SpringApplication springApplication(Class<?> configurationClass) {
        FunctionalSpringApplication application = new FunctionalSpringApplication(new Class[]{configurationClass});
        application.setWebApplicationType(WebApplicationType.NONE);
        return application;
    }
}

